/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.websvc.json.adapters;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class InetAddressAdapter
extends TypeAdapter<InetAddress> {
    public void write(JsonWriter writer, InetAddress value) throws IOException {
        if (value == null) {
            writer.nullValue();
            return;
        }
        writer.value(value.getHostAddress());
    }

    public InetAddress read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        try {
            return InetAddress.getByName(reader.nextString());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

