/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmList;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.VisibilityValidator;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;

public class ObjectAlarmBrowser
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.alarmviewer.views.ObjectAlarmBrowser";
    private CompositeWithMessageBar content;
    private AlarmList alarmView;
    private Action actionRefresh;
    private Action actionExportToCsv;
    private List<Long> objects = new ArrayList<Long>(1);

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String[] stringArray = site.getSecondaryId().split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                this.objects.add(Long.parseLong(id));
            }
            catch (NumberFormatException e) {
                Activator.logError("Invalid number in AlarmViewer secondary ID", e);
            }
            ++n2;
        }
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.content = new CompositeWithMessageBar(parent, 0);
        this.alarmView = new AlarmList((IViewPart)this, this.content.getContent(), 0, "ObjectAlarmBrowser", new VisibilityValidator(){

            public boolean isVisible() {
                return ObjectAlarmBrowser.this.getSite().getPage().isPartVisible((IWorkbenchPart)ObjectAlarmBrowser.this);
            }
        });
        this.alarmView.setRootObjects(this.objects);
        if (this.objects.size() == 1) {
            NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            this.setPartName(String.format(Messages.ObjectAlarmBrowser_Title, session.getObjectName(this.objects.get(0).longValue())));
        } else {
            Messages.get();
            this.setPartName(Messages.ObjectAlarmBrowser_TitleMultipleObjects);
            this.showObjectList();
        }
        this.createActions();
        this.contributeToActionBars();
        this.getSite().setSelectionProvider(this.alarmView.getSelectionProvider());
        this.getSite().getPage().addPartListener(new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                if (part == ObjectAlarmBrowser.this) {
                    ObjectAlarmBrowser.this.alarmView.doPendingUpdates();
                }
            }

            public void partActivated(IWorkbenchPart part) {
                if (part == ObjectAlarmBrowser.this) {
                    ObjectAlarmBrowser.this.alarmView.doPendingUpdates();
                }
            }
        });
    }

    private void showObjectList() {
        NXCSession session = ConsoleSharedData.getSession();
        StringBuilder sb = new StringBuilder();
        for (Long id : this.objects) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(session.getObjectName(id.longValue()));
        }
        Messages.get();
        this.content.showMessage(0, String.format(Messages.ObjectAlarmBrowser_SelectedObjects, sb.toString()));
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ObjectAlarmBrowser.this.alarmView.refresh();
                ObjectAlarmBrowser.this.showObjectList();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.alarmView.getViewer(), false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add(this.alarmView.getActionShowColors());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        this.alarmView.setFocus();
    }

    public void dispose() {
        this.alarmView.dispose();
        super.dispose();
    }
}

