/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.EditPaneWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementLayout;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.FontTools;
import org.netxms.ui.eclipse.tools.IntermediateSelectionProvider;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class ElementWidget
extends DashboardComposite
implements ControlListener {
    protected DashboardElement element;
    protected IViewPart viewPart;
    private Label title;
    private Composite content;
    private Font titleFont;
    private DashboardControl dbc;
    private DashboardElementLayout layout;
    private boolean editMode = false;
    private EditPaneWidget editPane = null;

    protected ElementWidget(DashboardControl parent, int style, DashboardElement element, IViewPart viewPart) {
        super((Composite)parent, style);
        this.dbc = parent;
        this.element = element;
        this.viewPart = viewPart;
        this.setupElement();
    }

    protected ElementWidget(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super((Composite)parent, 2048);
        this.dbc = parent;
        this.element = element;
        this.viewPart = viewPart;
        this.setupElement();
    }

    private void setupElement() {
        this.parseLayout(this.element.getLayout());
        this.addControlListener(this);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 4;
        this.setLayout((Layout)layout);
        this.content = new Composite((Composite)this, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                int mh;
                Point size = super.computeSize(wHint, hHint, changed);
                if (hHint == -1 && (mh = ElementWidget.this.getPreferredHeight()) > size.y) {
                    size.y = mh;
                }
                return size;
            }
        };
        this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.content.setLayout((Layout)new FillLayout());
        this.content.setBackground(this.getBackground());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ElementWidget.this.titleFont != null) {
                    ElementWidget.this.titleFont.dispose();
                }
            }
        });
    }

    protected Composite getContentArea() {
        return this.content;
    }

    protected int getPreferredHeight() {
        return 300;
    }

    protected void setTitle(String text, RGB backgroundColor, RGB foregroundColor, int textSizeAdjustment, String fontName) {
        if (this.title != null) {
            this.title.dispose();
        }
        this.title = new Label((Composite)this, 0x1000000);
        this.title.setText(text.replace("&", "&&"));
        if (backgroundColor != null) {
            this.title.setBackground(this.colors.create(backgroundColor));
            this.setBackground(this.title.getBackground());
        } else {
            this.title.setBackground(this.getBackground());
        }
        if (foregroundColor != null) {
            this.title.setForeground(this.colors.create(foregroundColor));
        }
        if (this.titleFont != null) {
            this.titleFont.dispose();
        }
        if (fontName != null && !fontName.isEmpty()) {
            Font systemFont = JFaceResources.getBannerFont();
            this.titleFont = FontTools.createFont((String[])new String[]{fontName}, (Font)JFaceResources.getBannerFont(), (int)textSizeAdjustment, (int)systemFont.getFontData()[0].getStyle());
            this.title.setFont(this.titleFont != null ? this.titleFont : systemFont);
        } else if (textSizeAdjustment != 0) {
            this.titleFont = FontTools.createAdjustedFont((Font)JFaceResources.getBannerFont(), (int)textSizeAdjustment);
            this.title.setFont(this.titleFont);
        } else {
            this.titleFont = null;
            this.title.setFont(JFaceResources.getBannerFont());
        }
        GridData gd = new GridData(0x1000000, 0x1000000, true, false);
        gd.verticalIndent = 4;
        this.title.setLayoutData((Object)gd);
        this.title.moveAbove(null);
        this.layout(true, true);
    }

    protected void processCommonSettings(DashboardElementConfig config) {
        if (!config.getTitle().isEmpty()) {
            this.setTitle(config.getTitle(), ColorConverter.parseColorDefinition((String)config.getTitleBackground()), ColorConverter.parseColorDefinition((String)config.getTitleForeground()), config.getTitleFontSize(), config.getTitleFontName());
        }
    }

    private void parseLayout(String json) {
        try {
            this.layout = (DashboardElementLayout)new Gson().fromJson(json, DashboardElementLayout.class);
        }
        catch (Exception e) {
            Activator.logError((String)"Cannot parse dashboard element layout", (Throwable)e);
            this.layout = new DashboardElementLayout();
        }
    }

    public DashboardElementLayout getElementLayout() {
        return this.layout;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        if (editMode) {
            this.editPane = new EditPaneWidget((Composite)this, this.dbc, this.element);
            this.editPane.setLocation(0, 0);
            this.editPane.setSize(this.getSize());
            this.editPane.moveAbove(null);
        } else if (this.editPane != null) {
            this.editPane.dispose();
            this.editPane = null;
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        if (this.editPane != null) {
            this.editPane.setLocation(0, 0);
            this.editPane.setSize(this.getSize());
            this.editPane.moveAbove(null);
        }
    }

    protected void setSelectionProviderDelegate(ISelectionProvider delegate) {
        this.dbc.getSelectionProvider().setSelectionProviderDelegate(delegate);
    }

    protected IntermediateSelectionProvider getSelectionProvider() {
        return this.dbc.getSelectionProvider();
    }

    protected void requestDashboardLayout() {
        this.dbc.requestDashboardLayout();
    }

    protected long getDashboardObjectId() {
        return this.dbc.getDashboardObject().getObjectId();
    }

    protected AbstractObject getContext() {
        return this.dbc.getContext();
    }

    protected long getContextObjectId() {
        AbstractObject object = this.dbc.getContext();
        return object != null ? object.getObjectId() : 0L;
    }

    protected long getEffectiveObjectId(long objectId) {
        return objectId == 0xFFFFFFFFL ? this.getContextObjectId() : objectId;
    }
}

