/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.elements;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.snmp.SnmpVersion;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.OverviewPageElement;
import org.netxms.ui.eclipse.objectview.objecttabs.elements.TableElement;

public class Capabilities
extends TableElement {
    public Capabilities(Composite parent, OverviewPageElement anchor, ObjectTab objectTab) {
        super(parent, anchor, objectTab);
    }

    @Override
    protected String getTitle() {
        Messages.get();
        return Messages.Capabilities_Title;
    }

    @Override
    protected void fillTable() {
        if (!(this.getObject() instanceof AbstractNode)) {
            return;
        }
        AbstractNode node = (AbstractNode)this.getObject();
        this.addFlag("802.1x", (node.getCapabilities() & 0x2000L) != 0L);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsAgent, (node.getCapabilities() & 2L) != 0L);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsBridge, (node.getCapabilities() & 4L) != 0L);
        this.addFlag("CDP", (node.getCapabilities() & 0x100L) != 0L);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagHasEntityMIB, (node.getCapabilities() & 0x8000L) != 0L);
        this.addFlag("EtherNet/IP", (node.getCapabilities() & 0x800000L) != 0L);
        this.addFlag("LLDP", (node.getCapabilities() & 0x400L) != 0L);
        this.addFlag("Modbus TCP", (node.getCapabilities() & 0x1000000L) != 0L);
        this.addFlag("NDP", (node.getCapabilities() & 0x200L) != 0L);
        this.addFlag("OSPF", (node.getCapabilities() & 0x40L) != 0L);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsPrinter, (node.getCapabilities() & 0x20L) != 0L);
        Messages.get();
        this.addFlag(Messages.Capabilities_FlagIsRouter, (node.getCapabilities() & 8L) != 0L);
        this.addFlag("SMCLP", (node.getCapabilities() & 0x100000L) != 0L);
        this.addFlag("SNMP", (node.getCapabilities() & 1L) != 0L);
        if ((node.getCapabilities() & 1L) != 0L) {
            Messages.get();
            this.addFlag(Messages.Capabilities_FlagHasIfXTable, (node.getCapabilities() & 0x10000L) != 0L);
            Messages.get();
            this.addPair(Messages.Capabilities_SNMPPort, Integer.toString(node.getSnmpPort()));
            Messages.get();
            this.addPair(Messages.Capabilities_SNMPVersion, this.getSnmpVersionName(node.getSnmpVersion()));
        }
        this.addFlag("SSH", (node.getCapabilities() & 0x80L) != 0L);
        this.addFlag("STP", (node.getCapabilities() & 0x4000L) != 0L);
        this.addFlag("User Agent", (node.getCapabilities() & 0x400000L) != 0L);
        this.addFlag("VRRP", (node.getCapabilities() & 0x800L) != 0L);
    }

    private void addFlag(String name, boolean value) {
        String string;
        if (value) {
            Messages.get();
            string = Messages.Capabilities_Yes;
        } else {
            Messages.get();
            string = Messages.Capabilities_No;
        }
        this.addPair(name, string);
    }

    private String getSnmpVersionName(SnmpVersion version) {
        switch (version) {
            case V1: {
                return "1";
            }
            case V2C: {
                return "2c";
            }
            case V3: {
                return "3";
            }
        }
        return "???";
    }

    @Override
    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof AbstractNode;
    }
}

