/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ICustomPaintListener;
import org.swtchart.ILineSeries;
import org.swtchart.IPlotArea;
import org.swtchart.ISeries;
import org.swtchart.ISeriesSet;
import org.swtchart.internal.Grid;
import org.swtchart.internal.series.Series;
import org.swtchart.internal.series.SeriesSet;

public class PlotArea
extends Canvas
implements PaintListener,
IPlotArea {
    protected Chart chart;
    protected SeriesSet seriesSet;
    private Image imageCache;
    private boolean updateImageCache;
    List<ICustomPaintListener> paintListeners;
    private static final int DEFAULT_BACKGROUND = 1;

    public PlotArea(Chart chart, int style) {
        super((Composite)chart, style | 0x40000);
        this.chart = chart;
        this.seriesSet = new SeriesSet(chart);
        this.updateImageCache = true;
        this.paintListeners = new ArrayList<ICustomPaintListener>();
        this.setBackground(Display.getDefault().getSystemColor(1));
        this.addPaintListener(this);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PlotArea.this.seriesSet != null) {
                    PlotArea.this.seriesSet.dispose();
                }
                if (PlotArea.this.imageCache != null) {
                    PlotArea.this.imageCache.dispose();
                }
            }
        });
    }

    public ISeriesSet getSeriesSet() {
        return this.seriesSet;
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        ((SeriesSet)this.getSeriesSet()).compressAllSeries();
    }

    public void setBackground(Color color) {
        if (color == null) {
            super.setBackground(Display.getDefault().getSystemColor(1));
        } else {
            super.setBackground(color);
        }
    }

    @Override
    public void addCustomPaintListener(ICustomPaintListener listener) {
        this.paintListeners.add(listener);
    }

    @Override
    public void removeCustomPaintListener(ICustomPaintListener listener) {
        this.paintListeners.remove(listener);
    }

    public void paintControl(PaintEvent e) {
        if (this.updateImageCache) {
            Point p = this.getSize();
            if (this.imageCache != null && !this.imageCache.isDisposed()) {
                this.imageCache.dispose();
            }
            this.imageCache = new Image((Device)Display.getCurrent(), p.x, p.y);
            GC gc = new GC((Drawable)this.imageCache);
            gc.setBackground(this.getBackground());
            gc.fillRectangle(0, 0, p.x, p.y);
            IAxis[] iAxisArray = this.chart.getAxisSet().getAxes();
            int n = iAxisArray.length;
            int n2 = 0;
            while (n2 < n) {
                IAxis axis = iAxisArray[n2];
                ((Grid)axis.getGrid()).draw(gc, p.x, p.y);
                ++n2;
            }
            GC prevGC = e.gc;
            e.gc = gc;
            for (ICustomPaintListener listener : this.paintListeners) {
                if (!listener.drawBehindSeries()) continue;
                listener.paintControl(e);
            }
            ISeries[] iSeriesArray = this.chart.getSeriesSet().getSeries();
            int n3 = iSeriesArray.length;
            int n4 = 0;
            while (n4 < n3) {
                ISeries series = iSeriesArray[n4];
                if (series instanceof IBarSeries) {
                    ((Series)series).draw(gc, p.x, p.y);
                }
                ++n4;
            }
            iSeriesArray = this.chart.getSeriesSet().getSeries();
            n3 = iSeriesArray.length;
            n4 = 0;
            while (n4 < n3) {
                ISeries series = iSeriesArray[n4];
                if (series instanceof ILineSeries) {
                    ((Series)series).draw(gc, p.x, p.y);
                }
                ++n4;
            }
            for (ICustomPaintListener listener : this.paintListeners) {
                if (listener.drawBehindSeries()) continue;
                listener.paintControl(e);
            }
            e.gc = prevGC;
            gc.dispose();
            this.updateImageCache = false;
        }
        e.gc.drawImage(this.imageCache, 0, 0);
    }

    public void update() {
        super.update();
        this.updateImageCache = true;
    }

    public void redraw() {
        super.redraw();
        this.updateImageCache = true;
    }
}

