/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import java.util.UUID;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.configs.MapDataSource;
import org.netxms.client.maps.elements.NetworkMapDCIImage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.ui.eclipse.imagelibrary.shared.ImageProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.DecorationLayerAbstractFigure;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkDciValueProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;

public class DCIImageFigure
extends DecorationLayerAbstractFigure {
    private static final int DEFAULT_SIZE = 30;
    private LinkDciValueProvider dciValueProvider;
    private DCIImageConfiguration dciImageConfiguration;

    public DCIImageFigure(NetworkMapDCIImage element, MapLabelProvider labelProvider, ExtendedGraphViewer viewer) {
        super((NetworkMapElement)element, viewer);
        this.dciImageConfiguration = element.getImageOptions();
        this.dciValueProvider = LinkDciValueProvider.getInstance();
        DciValue latDCIValue = this.dciValueProvider.getLastDciData((MapDataSource)this.dciImageConfiguration.getDci());
        try {
            UUID guid = this.dciImageConfiguration.getCorrectImage(latDCIValue);
            Rectangle bounds = ImageProvider.getInstance().getImage(guid).getBounds();
            this.setSize(bounds.width, bounds.height);
        }
        catch (IllegalArgumentException e) {
            this.setSize(30, 30);
        }
        this.setToolTip((IFigure)new Label(this.dciImageConfiguration.getDci().getName()));
    }

    @Override
    protected void paintFigure(Graphics gc) {
        DciValue latDCIValue = this.dciValueProvider.getLastDciData((MapDataSource)this.dciImageConfiguration.getDci());
        try {
            UUID guid = this.dciImageConfiguration.getCorrectImage(latDCIValue);
            Image image = ImageProvider.getInstance().getImage(guid);
            org.eclipse.draw2d.geometry.Rectangle rect = new org.eclipse.draw2d.geometry.Rectangle(this.getBounds());
            gc.drawImage(image, rect.x, rect.y);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public void refresh() {
        this.repaint();
    }
}

