/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.InetAddressListElement;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectSelectionFilterFactory;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectbrowser.widgets.ZoneSelector;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class AddressListElementEditDialog
extends Dialog {
    private Button radioSubnet;
    private Button radioRange;
    private LabeledText textAddr1;
    private LabeledText textAddr2;
    private LabeledText comments;
    private ZoneSelector zoneSelector;
    private ObjectSelector proxySelector;
    private InetAddressListElement element;
    private boolean enableProxySelection;
    private boolean warnOnWideMask;

    public AddressListElementEditDialog(Shell parentShell, boolean enableProxySelection, boolean warnOnWideMask, InetAddressListElement inetAddressListElement) {
        super(parentShell);
        this.enableProxySelection = enableProxySelection;
        this.warnOnWideMask = warnOnWideMask;
        this.element = inetAddressListElement;
    }

    protected void configureShell(Shell newShell) {
        String string;
        super.configureShell(newShell);
        if (this.element != null) {
            string = "Edit Address List Element";
        } else {
            Messages.get();
            string = Messages.AddAddressListElementDialog_Title;
        }
        newShell.setText(string);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.radioSubnet = new Button(dialogArea, 16);
        Messages.get();
        this.radioSubnet.setText(Messages.AddAddressListElementDialog_Subnet);
        this.radioSubnet.setSelection(true);
        this.radioSubnet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabeledText labeledText = AddressListElementEditDialog.this.textAddr1;
                Messages.get();
                labeledText.setLabel(Messages.AddAddressListElementDialog_NetAddr);
                LabeledText labeledText2 = AddressListElementEditDialog.this.textAddr2;
                Messages.get();
                labeledText2.setLabel(Messages.AddAddressListElementDialog_NetMask);
                if (AddressListElementEditDialog.this.textAddr2.getText().equals("0.0.0.0")) {
                    AddressListElementEditDialog.this.textAddr2.setText("0");
                }
            }
        });
        this.radioRange = new Button(dialogArea, 16);
        Messages.get();
        this.radioRange.setText(Messages.AddAddressListElementDialog_AddrRange);
        this.radioRange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabeledText labeledText = AddressListElementEditDialog.this.textAddr1;
                Messages.get();
                labeledText.setLabel(Messages.AddAddressListElementDialog_StartAddr);
                LabeledText labeledText2 = AddressListElementEditDialog.this.textAddr2;
                Messages.get();
                labeledText2.setLabel(Messages.AddAddressListElementDialog_EndAddr);
                if (AddressListElementEditDialog.this.textAddr2.getText().equals("0")) {
                    AddressListElementEditDialog.this.textAddr2.setText("0.0.0.0");
                }
            }
        });
        this.textAddr1 = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textAddr1.setLabel(Messages.AddAddressListElementDialog_NetAddr);
        this.textAddr1.setText("0.0.0.0");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textAddr1.setLayoutData((Object)gd);
        this.textAddr2 = new LabeledText(dialogArea, 0);
        Messages.get();
        this.textAddr2.setLabel(Messages.AddAddressListElementDialog_NetMask);
        this.textAddr2.setText("0");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textAddr2.setLayoutData((Object)gd);
        if (this.enableProxySelection) {
            if (ConsoleSharedData.getSession().isZoningEnabled()) {
                this.zoneSelector = new ZoneSelector(dialogArea, 0, true);
                this.zoneSelector.setLabel("Zone");
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.zoneSelector.setLayoutData((Object)gd);
            }
            this.proxySelector = new ObjectSelector(dialogArea, 0, true);
            this.proxySelector.setLabel("Proxy node");
            this.proxySelector.setClassFilter(ObjectSelectionFilterFactory.getInstance().createNodeSelectionFilter(false));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.proxySelector.setLayoutData((Object)gd);
        }
        this.comments = new LabeledText(dialogArea, 0);
        this.comments.setLabel("Comments");
        this.comments.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comments.setLayoutData((Object)gd);
        if (this.element != null) {
            this.radioSubnet.setSelection(this.element.isSubnet());
            this.radioRange.setSelection(!this.element.isSubnet());
            if (!this.element.isSubnet()) {
                Messages.get();
                this.textAddr1.setLabel(Messages.AddAddressListElementDialog_StartAddr);
                Messages.get();
                this.textAddr2.setLabel(Messages.AddAddressListElementDialog_EndAddr);
            }
            this.textAddr1.setText(this.element.getBaseAddress().getHostAddress());
            this.textAddr2.setText(this.element.isSubnet() ? Integer.toString(this.element.getMaskBits()) : this.element.getEndAddress().getHostAddress());
            if (this.enableProxySelection) {
                if (ConsoleSharedData.getSession().isZoningEnabled()) {
                    this.zoneSelector.setZoneUIN(this.element.getZoneUIN());
                }
                this.proxySelector.setObjectId(this.element.getProxyId());
            }
            this.comments.setText(this.element.getComment());
        }
        return dialogArea;
    }

    protected void okPressed() {
        try {
            long proxyId;
            int zoneUIN;
            int n = zoneUIN = this.zoneSelector != null ? this.zoneSelector.getZoneUIN() : 0;
            if (zoneUIN == -1) {
                zoneUIN = 0;
            }
            long l = proxyId = this.proxySelector != null ? this.proxySelector.getObjectId() : 0L;
            if (this.radioSubnet.getSelection()) {
                InetAddress baseAddress = InetAddress.getByName(this.textAddr1.getText().trim());
                int maskBits = Integer.parseInt(this.textAddr2.getText().trim());
                if (maskBits < 0 || baseAddress instanceof Inet4Address && maskBits > 32 || baseAddress instanceof Inet6Address && maskBits > 128) {
                    throw new NumberFormatException("Invalid network mask");
                }
                if (this.warnOnWideMask && maskBits < 16) {
                    Shell shell = this.getShell();
                    Messages.get();
                    if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.AddAddressListElementDialog_Warning, (String)"You have specified network mask that includes more than 65536 IP addresses. Do you really intend it?")) {
                        return;
                    }
                }
                if (this.element == null) {
                    this.element = new InetAddressListElement(baseAddress, maskBits, zoneUIN, proxyId, this.comments.getText());
                } else {
                    this.element.update(baseAddress, maskBits, zoneUIN, proxyId, this.comments.getText());
                }
            } else {
                byte[] bytes2;
                byte[] bytes1;
                InetAddress addr1 = InetAddress.getByName(this.textAddr1.getText().trim());
                InetAddress addr2 = InetAddress.getByName(this.textAddr2.getText().trim());
                if (this.warnOnWideMask && addr1 instanceof Inet4Address && addr2 instanceof Inet4Address && ((bytes1 = addr1.getAddress())[0] != (bytes2 = addr2.getAddress())[0] || bytes1[1] != bytes2[1])) {
                    Shell shell = this.getShell();
                    Messages.get();
                    if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.AddAddressListElementDialog_Warning, (String)"You have specified address range that includes more than 65536 IP addresses. Do you really intend it?")) {
                        return;
                    }
                }
                if (this.element == null) {
                    this.element = new InetAddressListElement(addr1, addr2, zoneUIN, proxyId, this.comments.getText());
                } else {
                    this.element.update(addr1, addr2, zoneUIN, proxyId, this.comments.getText());
                }
            }
        }
        catch (NumberFormatException | UnknownHostException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.AddAddressListElementDialog_Warning, (String)Messages.AddAddressListElementDialog_EnterValidData);
            return;
        }
        super.okPressed();
    }

    public InetAddressListElement getElement() {
        return this.element;
    }
}

