/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.dashboards.config;

import com.google.gson.Gson;
import org.eclipse.swt.graphics.RGB;
import org.netxms.client.xml.XMLTools;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.tools.ColorConverter;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Root(name="element", strict=false)
public class LabelConfig
extends DashboardElementConfig {
    private static final Logger logger = LoggerFactory.getLogger(LabelConfig.class);
    @Element(required=false)
    private String foreground = null;
    @Element(required=false)
    private String background = null;

    public static LabelConfig createFromXmlOrJson(String data) throws Exception {
        LabelConfig config = data.trim().startsWith("<") ? (LabelConfig)XMLTools.createFromXml(LabelConfig.class, (String)data) : (LabelConfig)new Gson().fromJson(data, LabelConfig.class);
        if (config.foreground != null && config.foreground.startsWith("0x")) {
            try {
                config.setTitleForeground(ColorConverter.rgbToCss((RGB)ColorConverter.rgbFromInt((int)Integer.parseInt(config.foreground.substring(2), 16))));
            }
            catch (NumberFormatException e) {
                logger.warn("Cannot convert label foreground color \"" + config.foreground + "\"", (Throwable)e);
            }
            config.foreground = null;
        }
        if (config.background != null && config.background.startsWith("0x")) {
            try {
                config.setTitleBackground(ColorConverter.rgbToCss((RGB)ColorConverter.rgbFromInt((int)Integer.parseInt(config.background.substring(2), 16))));
            }
            catch (NumberFormatException e) {
                logger.warn("Cannot convert label background color \"" + config.background + "\"", (Throwable)e);
            }
            config.background = null;
        }
        return config;
    }
}

