/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyDialog;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.propertypages.SummaryTableColumns;
import org.netxms.nxmc.modules.datacollection.propertypages.SummaryTableFilterPropertyPage;
import org.netxms.nxmc.modules.datacollection.propertypages.SummaryTableGeneral;
import org.netxms.nxmc.modules.datacollection.views.helpers.SummaryTableComparator;
import org.netxms.nxmc.modules.datacollection.views.helpers.SummaryTableFilter;
import org.netxms.nxmc.modules.datacollection.views.helpers.SummaryTableLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public class SummaryTableManager
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(SummaryTableManager.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_MENU_PATH = 1;
    public static final int COLUMN_TITLE = 2;
    private SortableTableViewer viewer;
    private NXCSession session;
    private SessionListener listener = null;
    private Map<Integer, DciSummaryTableDescriptor> descriptors = new HashMap();
    private Action actionCreateSingleValue;
    private Action actionCreateTableValue;
    private Action actionEdit;
    private Action actionDelete;

    public SummaryTableManager() {
        super(LocalizationHelper.getI18n(SummaryTableManager.class).tr("DCI Summary Tables"), ResourceManager.getImageDescriptor((String)"icons/config-views/summary_table.png"), "configuration.summary-tables", true);
        this.session = Registry.getSession();
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Menu Path"), this.i18n.tr("Title")};
        int[] widths = new int[]{90, 250, 200};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 128, -1);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SummaryTableLabelProvider());
        this.viewer.setComparator((ViewerComparator)new SummaryTableComparator());
        SummaryTableFilter filter = new SummaryTableFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.refresh();
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.listener);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createActions() {
        this.actionCreateSingleValue = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateTableValue = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit.setEnabled(false);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setEnabled(false);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionCreateSingleValue);
        manager.add((IAction)this.actionCreateTableValue);
        super.fillLocalToolBar(manager);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void createSummaryTable(boolean isTableSource) {
        DciSummaryTable t = new DciSummaryTable("", "", isTableSource);
        if (this.showPropertyPages(t, true)) {
            DciSummaryTableDescriptor d = new DciSummaryTableDescriptor(t);
            this.descriptors.put(d.getId(), d);
            this.viewer.setInput((Object)this.descriptors.values().toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)d));
        }
    }

    private boolean showPropertyPages(DciSummaryTable t, boolean isNew) {
        PreferenceManager pm = new PreferenceManager();
        pm.addToRoot((IPreferenceNode)new PreferenceNode("general", (IPreferencePage)new SummaryTableGeneral(t)));
        pm.addToRoot((IPreferenceNode)new PreferenceNode("filter", (IPreferencePage)new SummaryTableFilterPropertyPage(t)));
        if (!t.isTableSoure()) {
            pm.addToRoot((IPreferenceNode)new PreferenceNode("columns", (IPreferencePage)new SummaryTableColumns(t)));
        }
        PropertyDialog dlg = new PropertyDialog(this.getWindow().getShell(), pm, isNew ? this.i18n.tr("Create DCI Summary Table") : this.i18n.tr("Edit Summary Table"));
        return dlg.open() == 0;
    }

    private void editSummaryTable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        DciSummaryTableDescriptor d = (DciSummaryTableDescriptor)selection.getFirstElement();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Confirm Delete"), (String)this.i18n.tr("Selected DCI summary tables will be deleted. Are you really sure?"))) {
            return;
        }
        int[] idList = new int[selection.size()];
        int i = 0;
        for (Object o : selection.toList()) {
            idList[i++] = ((DciSummaryTableDescriptor)o).getId();
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void dispose() {
        if (this.session != null && this.listener != null) {
            this.session.removeListener(this.listener);
        }
        super.dispose();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

