/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.objects.MutableObjectCategory;
import org.netxms.client.objects.ObjectCategory;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ObjectCategoryEditDialog;
import org.netxms.nxmc.modules.objects.views.helpers.ObjectCategoryComparator;
import org.netxms.nxmc.modules.objects.views.helpers.ObjectCategoryFilter;
import org.netxms.nxmc.modules.objects.views.helpers.ObjectCategoryLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ObjectCategoryManager
extends ConfigurationView
implements SessionListener {
    private final I18n i18n = LocalizationHelper.getI18n(ObjectCategoryManager.class);
    public static final int COL_ID = 0;
    public static final int COL_NAME = 1;
    public static final int COL_ICON = 2;
    public static final int COL_MAP_IMAGE = 3;
    private static final String TABLE_CONFIG_PREFIX = "ObjectCategoryManager";
    private Map<Integer, ObjectCategory> categories = new HashMap();
    private SortableTableViewer viewer;
    private NXCSession session = Registry.getSession();
    private ObjectCategoryFilter filter;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;

    public ObjectCategoryManager() {
        super(LocalizationHelper.getI18n(ObjectCategoryManager.class).tr("Object Categories"), ResourceManager.getImageDescriptor((String)"icons/config-views/object-categories.png"), "objects.categories", true);
    }

    public void createContent(Composite parent) {
        String[] names = new String[]{this.i18n.tr("ID"), this.i18n.tr("Name"), this.i18n.tr("Icon"), this.i18n.tr("Map image")};
        int[] widths = new int[]{100, 500, 200, 200};
        this.viewer = new SortableTableViewer(parent, names, widths, 1, 1024, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ObjectCategoryLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ObjectCategoryComparator());
        this.filter = new ObjectCategoryFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        this.session.addListener((SessionListener)this);
        this.refresh();
    }

    protected void postContentCreate() {
        super.postContentCreate();
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }

    public void notificationHandler(SessionNotification n) {
        if (n.getCode() == 1048) {
            this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        } else if (n.getCode() == 1049) {
            this.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void createActions() {
        this.actionNew = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+N", (IAction)this.actionNew);
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M3+ENTER", (IAction)this.actionEdit);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("M1+D", (IAction)this.actionDelete);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
    }

    private void createCategory() {
        ObjectCategoryEditDialog dlg = new ObjectCategoryEditDialog(this.getWindow().getShell(), null);
        if (dlg.open() == 0) {
            this.updateCategory(dlg.getCategory());
        }
    }

    private void editCategory() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        ObjectCategoryEditDialog dlg = new ObjectCategoryEditDialog(this.getWindow().getShell(), new MutableObjectCategory((ObjectCategory)selection.getFirstElement()));
        if (dlg.open() == 0) {
            this.updateCategory(dlg.getCategory());
        }
    }

    private void updateCategory(MutableObjectCategory category) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteCategories() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Delete Object Categories"), (String)this.i18n.tr("Selected object categories will be deleted. Are you sure?"))) {
            return;
        }
        int[] idList = new int[selection.size()];
        int index = 0;
        for (Object o : selection.toList()) {
            idList[index++] = ((ObjectCategory)o).getId();
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public void refresh() {
        this.categories.clear();
        for (ObjectCategory c : this.session.getObjectCategories()) {
            this.categories.put(c.getId(), c);
        }
        this.viewer.setInput(this.categories.values());
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

