/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.widgets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.TcpPortForwarder;
import org.netxms.ui.eclipse.objecttools.widgets.AbstractObjectToolExecutor;

public class LocalCommandExecutor
extends AbstractObjectToolExecutor {
    private ObjectTool tool;
    private Process process;
    private TcpPortForwarder tcpPortForwarder = null;
    private boolean processRunning = false;
    private String command;
    private Object mutex = new Object();

    public LocalCommandExecutor(Composite resultArea, ViewPart view, ObjectContext objectContext, AbstractObjectToolExecutor.ActionSet actionSet, ObjectTool tool, String command) {
        super(resultArea, view, objectContext, actionSet);
        this.tool = tool;
        this.command = command;
        this.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent e) {
                Object object = LocalCommandExecutor.this.mutex;
                synchronized (object) {
                    if (LocalCommandExecutor.this.processRunning) {
                        LocalCommandExecutor.this.process.destroy();
                        if (LocalCommandExecutor.this.tcpPortForwarder != null) {
                            LocalCommandExecutor.this.tcpPortForwarder.close();
                            LocalCommandExecutor.this.tcpPortForwarder = null;
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeInternal(Display display) throws Exception {
        block30: {
            Process process;
            String commandLine;
            Object object = this.mutex;
            synchronized (object) {
                if (this.processRunning) {
                    this.process.destroy();
                    try {
                        this.mutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.tcpPortForwarder != null) {
                        this.tcpPortForwarder.close();
                        this.tcpPortForwarder = null;
                    }
                }
                this.processRunning = true;
            }
            if ((this.tool.getFlags() & 0x80) != 0) {
                this.tcpPortForwarder = new TcpPortForwarder(this.session, this.objectContext.object.getObjectId(), this.tool.getRemotePort(), 0);
                this.tcpPortForwarder.setConsoleOutputStream(this.out);
                this.tcpPortForwarder.run();
                commandLine = this.command.replace("${local-port}", Integer.toString(this.tcpPortForwarder.getLocalPort()));
            } else {
                commandLine = this.command;
            }
            if (Platform.getOS().equals("win32")) {
                commandLine = "CMD.EXE /C START \"NetXMS\" " + commandLine;
                process = Runtime.getRuntime().exec(this.command);
            } else {
                process = Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", commandLine});
            }
            InputStream in = process.getInputStream();
            try {
                try {
                    int bytes;
                    byte[] data = new byte[16384];
                    boolean isWindows = Platform.getOS().equals("win32");
                    while ((bytes = in.read(data)) != -1) {
                        String s = new String(Arrays.copyOf(data, bytes));
                        if (isWindows) {
                            this.out.write(s.replace("\r\r\n", " \r\n"));
                            continue;
                        }
                        this.out.write(s);
                    }
                    Messages.get();
                    this.out.write(Messages.LocalCommandResults_Terminated);
                }
                catch (IOException e) {
                    Activator.logError("Exception while running local command", e);
                    in.close();
                    Object object2 = this.mutex;
                    synchronized (object2) {
                        this.processRunning = false;
                        process = null;
                        if (this.tcpPortForwarder != null) {
                            this.tcpPortForwarder.close();
                            this.tcpPortForwarder = null;
                        }
                        this.mutex.notifyAll();
                        break block30;
                    }
                }
            }
            catch (Throwable throwable) {
                in.close();
                Object object3 = this.mutex;
                synchronized (object3) {
                    this.processRunning = false;
                    process = null;
                    if (this.tcpPortForwarder != null) {
                        this.tcpPortForwarder.close();
                        this.tcpPortForwarder = null;
                    }
                    this.mutex.notifyAll();
                }
                throw throwable;
            }
            in.close();
            Object object4 = this.mutex;
            synchronized (object4) {
                this.processRunning = false;
                process = null;
                if (this.tcpPortForwarder != null) {
                    this.tcpPortForwarder.close();
                    this.tcpPortForwarder = null;
                }
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.processRunning) {
                this.process.destroy();
            }
        }
    }

    @Override
    protected boolean isTerminateSupported() {
        return true;
    }
}

