/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.EventMonitorConfig;
import org.netxms.ui.eclipse.eventmanager.widgets.EventTraceWidget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class EventMonitorElement
extends ElementWidget {
    private EventTraceWidget viewer;
    private EventMonitorConfig config;
    private final NXCSession session;

    protected EventMonitorElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = (EventMonitorConfig)new Gson().fromJson(element.getData(), EventMonitorConfig.class);
        }
        catch (Exception e) {
            Activator.logError((String)"Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new EventMonitorConfig();
        }
        this.processCommonSettings(this.config);
        this.session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Subscribing to channel %s", "Core.Events"), (IWorkbenchPart)viewPart, "org.netxms.ui.eclipse.console", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                EventMonitorElement.this.session.subscribe("Core.Events");
            }

            protected String getErrorMessage() {
                return String.format("Cannot subscribe to channel %s", "Core.Events");
            }
        }.start();
        this.viewer = new EventTraceWidget(this.getContentArea(), 0, viewPart);
        this.viewer.setRootObject(this.getEffectiveObjectId(this.config.getObjectId()));
        this.viewer.getViewer().getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                EventMonitorElement.this.setSelectionProviderDelegate(EventMonitorElement.this.viewer.getSelectionProvider());
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EventMonitorElement.this.unsubscribe();
            }
        });
    }

    private void unsubscribe() {
        ConsoleJob job = new ConsoleJob(String.format("Unsuscribing from channel %s", "Core.Events"), null, "org.netxms.ui.eclipse.console"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                EventMonitorElement.this.session.unsubscribe("Core.Events");
            }

            protected String getErrorMessage() {
                return String.format("Cannot unsubscribe from channel %s", "Core.Events");
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
        super.dispose();
    }
}

