/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.widgets.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.TableRow;
import org.netxms.client.constants.DataType;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableItemComparator
extends ViewerComparator {
    private DataType[] formats;

    public TableItemComparator(DataType[] formats) {
        this.formats = formats;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        DataType format = column < this.formats.length ? this.formats[column] : DataType.STRING;
        String value1 = ((TableRow)e1).get(column).getValue();
        String value2 = ((TableRow)e2).get(column).getValue();
        int result = switch (format) {
            case DataType.STRING -> value1.compareToIgnoreCase(value2);
            case DataType.INT32 -> {
                try {
                    yield Integer.parseInt(value1) - Integer.parseInt(value2);
                }
                catch (NumberFormatException e) {
                    yield 0;
                }
            }
            case DataType.UINT32, DataType.INT64, DataType.UINT64, DataType.COUNTER32, DataType.COUNTER64 -> {
                try {
                    yield Long.signum(Long.parseLong(value1) - Long.parseLong(value2));
                }
                catch (NumberFormatException e) {
                    yield 0;
                }
            }
            case DataType.FLOAT -> {
                try {
                    yield (int)Math.signum(Double.parseDouble(value1) - Double.parseDouble(value2));
                }
                catch (NumberFormatException e) {
                    yield 0;
                }
            }
            default -> 0;
        };
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }
}

