/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DeviceBackupJobStatus {
    SUCCESSFUL(0),
    FAILED(1),
    UNKNOWN(2);

    private static Logger logger;
    private static Map<Integer, DeviceBackupJobStatus> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(DeviceBackupJobStatus.class);
        lookupTable = new HashMap<Integer, DeviceBackupJobStatus>();
        DeviceBackupJobStatus[] deviceBackupJobStatusArray = DeviceBackupJobStatus.values();
        int n = deviceBackupJobStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            DeviceBackupJobStatus element = deviceBackupJobStatusArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private DeviceBackupJobStatus(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DeviceBackupJobStatus getByValue(int value) {
        DeviceBackupJobStatus element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }
}

