/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.OSPFNeighborState;

public class OSPFNeighbor {
    private InetAddress routerId;
    private InetAddress ipAddress;
    private long nodeId;
    private boolean virtual;
    private int interfaceIndex;
    private long interfaceId;
    private InetAddress areaId;
    private OSPFNeighborState state;

    public OSPFNeighbor(NXCPMessage msg, long baseId) {
        this.routerId = msg.getFieldAsInetAddress(baseId);
        this.nodeId = msg.getFieldAsInt64(baseId + 1L);
        this.ipAddress = msg.getFieldAsInetAddress(baseId + 2L);
        this.interfaceIndex = msg.getFieldAsInt32(baseId + 3L);
        this.interfaceId = msg.getFieldAsInt64(baseId + 4L);
        this.areaId = msg.getFieldAsInetAddress(baseId + 5L);
        this.virtual = msg.getFieldAsBoolean(baseId + 6L);
        this.state = OSPFNeighborState.getByValue(msg.getFieldAsInt32(baseId + 7L));
    }

    public InetAddress getRouterId() {
        return this.routerId;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public int getInterfaceIndex() {
        return this.interfaceIndex;
    }

    public long getInterfaceId() {
        return this.interfaceId;
    }

    public InetAddress getAreaId() {
        return this.virtual ? this.areaId : null;
    }

    public OSPFNeighborState getState() {
        return this.state;
    }
}

