/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.users;

import org.netxms.base.NXCPMessage;
import org.netxms.client.users.AbstractUserObject;

public class UserGroup
extends AbstractUserObject {
    private int[] members;

    public UserGroup(String name) {
        super(name, "group");
        this.members = new int[0];
    }

    public UserGroup(UserGroup src) {
        super(src);
        this.members = new int[src.members.length];
        System.arraycopy(src.members, 0, this.members, 0, src.members.length);
    }

    public UserGroup(NXCPMessage msg) {
        super(msg, "group");
        int count = msg.getFieldAsInt32(38L);
        this.members = new int[count];
        int i = 0;
        while (i < count) {
            this.members[i] = msg.getFieldAsInt32(16384L + (long)i);
            ++i;
        }
    }

    @Override
    public void fillMessage(NXCPMessage msg) {
        super.fillMessage(msg);
        msg.setFieldInt32(38L, this.members.length);
        int i = 0;
        while (i < this.members.length) {
            msg.setFieldInt32(16384L + (long)i, this.members[i]);
            ++i;
        }
    }

    public int[] getMembers() {
        return this.members;
    }

    public void setMembers(int[] members) {
        this.members = members;
    }
}

