/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OSPFNeighborState {
    UNKNOWN(0, ""),
    DOWN(1, "DOWN"),
    ATTEMPT(2, "ATTEMPT"),
    INIT(3, "INIT"),
    TWO_WAY(4, "TWO-WAY"),
    EXCHANGE_START(5, "EXCHANGE START"),
    EXCHANGE(6, "EXCHANGE"),
    LOADING(7, "LOADING"),
    FULL(8, "FULL");

    private static Logger logger;
    private static Map<Integer, OSPFNeighborState> lookupTable;
    private int value;
    private String text;

    static {
        logger = LoggerFactory.getLogger(OSPFNeighborState.class);
        lookupTable = new HashMap<Integer, OSPFNeighborState>();
        OSPFNeighborState[] oSPFNeighborStateArray = OSPFNeighborState.values();
        int n = oSPFNeighborStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            OSPFNeighborState element = oSPFNeighborStateArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private OSPFNeighborState(int value, String text) {
        this.value = value;
        this.text = text;
    }

    public int getValue() {
        return this.value;
    }

    public String getText() {
        return this.text;
    }

    public static OSPFNeighborState getByValue(int value) {
        OSPFNeighborState element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }
}

