/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Script;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.Activator;
import org.netxms.ui.eclipse.nxsl.Messages;
import org.netxms.ui.eclipse.nxsl.dialogs.CreateScriptDialog;
import org.netxms.ui.eclipse.nxsl.views.helpers.ScriptComparator;
import org.netxms.ui.eclipse.nxsl.views.helpers.ScriptFilter;
import org.netxms.ui.eclipse.nxsl.views.helpers.ScriptLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ScriptLibrary
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.nxsl.views.ScriptLibrary";
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    private static final String TABLE_CONFIG_PREFIX = "ScriptLibrary";
    private NXCSession session;
    private SortableTableViewer viewer;
    private RefreshAction actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionRename;
    private Action actionDelete;
    private Action actionCopyName;
    private Action actionShowFilter;
    private ScriptFilter filter;
    private FilterText filterText;
    private IDialogSettings settings;
    private Composite content;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.settings = Activator.getDefault().getDialogSettings();
    }

    public void createPartControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScriptLibrary.this.onFilterModify();
            }
        });
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.ScriptLibrary_ColumnId;
        Messages.get();
        stringArray[1] = Messages.ScriptLibrary_ColumnName;
        String[] names = stringArray;
        int[] widths = new int[]{70, 400};
        this.viewer = new SortableTableViewer(this.content, names, widths, 0, 128, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ScriptLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ScriptComparator());
        this.filter = new ScriptFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    ScriptLibrary.this.actionEdit.setEnabled(selection.size() == 1);
                    ScriptLibrary.this.actionRename.setEnabled(selection.size() == 1);
                    ScriptLibrary.this.actionDelete.setEnabled(selection.size() > 0);
                    ScriptLibrary.this.actionCopyName.setEnabled(selection.size() == 1);
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ScriptLibrary.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)ScriptLibrary.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)ScriptLibrary.TABLE_CONFIG_PREFIX);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.filterText.setCloseAction(new Action(){

            public void run() {
                ScriptLibrary.this.enableFilter(false);
                ScriptLibrary.this.actionShowFilter.setChecked(false);
            }
        });
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        if (this.actionShowFilter.isChecked()) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refreshScriptList();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.nxsl.context.ScriptLibrary");
        }
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction(){

            public void run() {
                ScriptLibrary.this.refreshScriptList();
            }
        };
        Messages.get();
        this.actionNew = new Action(Messages.ScriptLibrary_New, Activator.getImageDescriptor("icons/new.png")){

            public void run() {
                ScriptLibrary.this.createNewScript();
            }
        };
        Messages.get();
        this.actionEdit = new Action(Messages.ScriptLibrary_Edit, Activator.getImageDescriptor("icons/edit.png")){

            public void run() {
                ScriptLibrary.this.editScript();
            }
        };
        this.actionEdit.setEnabled(false);
        Messages.get();
        this.actionRename = new Action(Messages.ScriptLibrary_Rename){

            public void run() {
                ScriptLibrary.this.renameScript();
            }
        };
        this.actionRename.setEnabled(false);
        Messages.get();
        this.actionDelete = new Action(Messages.ScriptLibrary_Delete, Activator.getImageDescriptor("icons/delete.png")){

            public void run() {
                ScriptLibrary.this.deleteScript();
            }
        };
        this.actionDelete.setEnabled(false);
        this.actionCopyName = new Action("Copy name", SharedIcons.COPY){

            public void run() {
                ScriptLibrary.this.copyNameToClipboard();
            }
        };
        this.actionCopyName.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.CopyNameToClipboard");
        handlerService.activateHandler(this.actionCopyName.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopyName));
        this.actionShowFilter = new Action("Show filter", 2){

            public void run() {
                ScriptLibrary.this.enableFilter(ScriptLibrary.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.getBooleanFromSettings("ScriptLibrary.showFilter", true));
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionDelete);
        manager.add((IAction)this.actionRename);
        manager.add((IAction)this.actionEdit);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ScriptLibrary.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionRename);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IAction)this.actionCopyName);
    }

    private void refreshScriptList() {
        Messages.get();
        new ConsoleJob(Messages.ScriptLibrary_LoadJobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScriptLibrary_LoadJobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List library = ScriptLibrary.this.session.getScriptLibrary();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ScriptLibrary.this.viewer.setInput((Object)library.toArray());
                    }
                });
            }
        }.start();
    }

    private void createNewScript() {
        final CreateScriptDialog dlg = new CreateScriptDialog(this.getSite().getShell(), null);
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.ScriptLibrary_CreateJobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final long id = ScriptLibrary.this.session.modifyScript(0L, dlg.getName(), "");
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Object[] input = (Object[])(this).ScriptLibrary.this.viewer.getInput();
                            ArrayList<Script> list = new ArrayList<Script>(input.length);
                            Object[] objectArray = input;
                            int n = input.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                list.add((Script)o);
                                ++n2;
                            }
                            Script script = new Script(id, dlg.getName(), "");
                            list.add(script);
                            (this).ScriptLibrary.this.viewer.setInput((Object)list.toArray());
                            (this).ScriptLibrary.this.viewer.setSelection((ISelection)new StructuredSelection((Object)script));
                            (this).ScriptLibrary.this.actionEdit.run();
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ScriptLibrary_CreateJobError;
                }
            }.start();
        }
    }

    private void editScript() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Script script = (Script)selection.getFirstElement();
        try {
            this.getSite().getPage().showView("org.netxms.ui.eclipse.nxsl.views.ScriptEditorView", Long.toString(script.getId()), 1);
        }
        catch (PartInitException e) {
            Shell shell = this.getSite().getWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ScriptLibrary_Error, (String)String.format(Messages.ScriptLibrary_EditScriptError, e.getMessage()));
        }
    }

    private void renameScript() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        final Script script = (Script)selection.getFirstElement();
        final CreateScriptDialog dlg = new CreateScriptDialog(this.getSite().getShell(), script.getName());
        if (dlg.open() == 0) {
            Messages.get();
            new ConsoleJob(Messages.ScriptLibrary_RenameJobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ScriptLibrary.this.session.renameScript(script.getId(), dlg.getName());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Object[] input = (Object[])(this).ScriptLibrary.this.viewer.getInput();
                            ArrayList<Script> list = new ArrayList<Script>(input.length);
                            Object[] objectArray = input;
                            int n = input.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object o = objectArray[n2];
                                if (((Script)o).getId() != script.getId()) {
                                    list.add((Script)o);
                                }
                                ++n2;
                            }
                            Script newScript = new Script(script.getId(), dlg.getName(), script.getSource());
                            list.add(newScript);
                            (this).ScriptLibrary.this.viewer.setInput((Object)list.toArray());
                            (this).ScriptLibrary.this.viewer.setSelection((ISelection)new StructuredSelection((Object)newScript));
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.ScriptLibrary_RenameJobError;
                }
            }.start();
        }
    }

    private void deleteScript() {
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.ScriptLibrary_Confirmation, (String)Messages.ScriptLibrary_ConfirmationText)) {
            return;
        }
        final IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Messages.get();
        new ConsoleJob(Messages.ScriptLibrary_DeleteJobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (Script script : selection) {
                    ScriptLibrary.this.session.deleteScript(script.getId());
                }
            }

            protected void jobFinalize() {
                ScriptLibrary.this.refreshScriptList();
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScriptLibrary_DeleteJobError;
            }
        }.start();
    }

    private void copyNameToClipboard() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        WidgetHelper.copyToClipboard((String)((Script)selection.getFirstElement()).getName());
    }

    private void enableFilter(boolean enable) {
        this.filterText.setVisible(enable);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
        this.settings.put("ScriptLibrary.showFilter", enable);
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private boolean getBooleanFromSettings(String name, boolean defval) {
        String v = this.settings.get(name);
        return v != null ? Boolean.valueOf(v) : defval;
    }
}

