/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.DciIdMatchingData;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Root(name="element", strict=false)
public class TableValueConfig
extends DashboardElementConfig {
    @Element(required=true)
    private long objectId = 0L;
    @Element(required=true)
    private long dciId = 0L;
    @Element(required=false)
    public String dciName;
    @Element(required=false)
    public String dciDescription;
    @Element(required=false)
    private int refreshRate = 30;

    @Override
    public Set<Long> getObjects() {
        Set<Long> objects = super.getObjects();
        objects.add(this.objectId);
        return objects;
    }

    @Override
    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.objectId);
        if (md != null) {
            this.objectId = md.dstId;
        }
    }

    @Override
    public Map<Long, Long> getDataCollectionItems() {
        HashMap<Long, Long> dcis = new HashMap<Long, Long>();
        dcis.put(this.dciId, this.objectId);
        return dcis;
    }

    @Override
    public void remapDataCollectionItems(Map<Long, DciIdMatchingData> remapData) {
        super.remapDataCollectionItems(remapData);
        DciIdMatchingData md = remapData.get(this.dciId);
        if (md != null) {
            this.objectId = md.dstNodeId;
            this.dciId = md.dstDciId;
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public void setObjectId(long objectId) {
        this.objectId = objectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public void setDciId(long dciId) {
        this.dciId = dciId;
    }

    public String getDciName() {
        return this.dciName != null ? this.dciName : "";
    }

    public void setDciName(String dciName) {
        this.dciName = dciName;
    }

    public String getDciDescription() {
        return this.dciDescription != null ? this.dciDescription : "";
    }

    public void setDciDescription(String dciDescription) {
        this.dciDescription = dciDescription;
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }
}

