/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.jobs;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.netxms.nxmc.base.jobs.Job;

public class JobManager {
    private static JobManager instance = new JobManager();
    private Map<Integer, Job> jobs = new HashMap();
    private ExecutorService threadPool = Executors.newCachedThreadPool((ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
    private int jobId = 0;

    public static JobManager getInstance() {
        return instance;
    }

    private JobManager() {
    }

    protected synchronized void submit(Job job, IProgressMonitor monitor) {
        job.setId(this.jobId++);
        this.jobs.put(job.getId(), job);
        this.threadPool.execute(() -> {
            job.execute(monitor);
            this.onJobCompletion(job);
        });
    }

    protected synchronized void schedule(Job job, long delay) {
        job.setId(this.jobId++);
        job.setScheduledState();
        this.jobs.put(job.getId(), job);
        this.scheduler.schedule(() -> this.threadPool.execute(() -> {
            job.execute(null);
            this.onJobCompletion(job);
        }), delay, TimeUnit.MILLISECONDS);
    }

    private synchronized void onJobCompletion(Job job) {
        this.jobs.remove(job.getId());
    }
}

