/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.views;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.xnap.commons.i18n.I18n;

public abstract class ConfigurationView
extends View {
    private I18n i18n = LocalizationHelper.getI18n(ConfigurationView.class);

    public ConfigurationView(String name, ImageDescriptor image, String id, boolean hasFilter) {
        super(name, image, id, hasFilter);
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    public abstract boolean isModified();

    public abstract void save();

    public String getSaveOnExitPrompt() {
        return this.i18n.tr("There are unsaved changes in current view. Do you want to save them?");
    }

    public boolean beforeClose() {
        if (!this.isModified()) {
            return true;
        }
        int choice = MessageDialogHelper.openQuestionWithCancel((Shell)this.getWindow().getShell(), (String)this.i18n.tr("Unsaved Changes"), (String)this.getSaveOnExitPrompt());
        if (choice == 2) {
            return false;
        }
        if (choice == 0) {
            this.save();
        }
        return true;
    }
}

