/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class FilterText
extends Composite {
    private I18n i18n = LocalizationHelper.getI18n(FilterText.class);
    private Text text;
    private Composite buttonArea;
    private Composite textArea;
    private List<Button> attrButtons = new ArrayList(4);
    private Label tooltipIcon;
    private Label closeButton;
    private Label clearButton;
    private Action closeAction = null;
    private Runnable closeCallback = null;
    private boolean autoApply = true;
    private int delay = 300;
    private int minLength = 1;
    private Set<ModifyListener> modifyListeners = new HashSet();
    private ModifyEvent lastModifyEvent = null;
    private ContentProposalAdapter proposalAdapter = null;
    private Color defaultBackground;

    public FilterText(Composite parent, int style) {
        this(parent, style, null, true, true, null);
    }

    public FilterText(Composite parent, int style, String tooltip, boolean showFilterCloseButton) {
        this(parent, style, tooltip, showFilterCloseButton, true, null);
    }

    public FilterText(Composite parent, int style, String tooltip, boolean showFilterCloseButton, boolean showFilterLabel) {
        this(parent, style, tooltip, showFilterCloseButton, showFilterLabel, null);
    }

    public FilterText(Composite parent, int style, String tooltip, boolean showFilterCloseButton, boolean showFilterLabel, IContentProposalProvider proposalProvider) {
        super(parent, style);
        GridData gd;
        GridLayout layout = new GridLayout();
        layout.numColumns = showFilterLabel ? 5 : 4;
        this.setLayout((Layout)layout);
        if (showFilterLabel) {
            Label label = new Label((Composite)this, 0);
            label.setText(this.i18n.tr("Filter:"));
            gd = new GridData();
            gd.verticalAlignment = 0x1000000;
            label.setLayoutData((Object)gd);
        }
        this.textArea = new Composite((Composite)this, 2048);
        GridLayout textLayout = new GridLayout();
        textLayout.numColumns = 2;
        textLayout.marginBottom = 0;
        textLayout.marginTop = 0;
        textLayout.marginLeft = 0;
        textLayout.marginRight = 0;
        this.textArea.setLayout((Layout)textLayout);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.textArea.setLayoutData((Object)gd);
        this.text = new Text(this.textArea, 4);
        this.text.setTextLimit(64);
        this.text.setMessage(this.i18n.tr("Filter is empty"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 0x1000000;
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.text.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        if (tooltip != null) {
            this.tooltipIcon = new Label(this.textArea, 0);
            this.tooltipIcon.setImage(SharedIcons.IMG_INFORMATION);
            gd = new GridData();
            gd.verticalAlignment = 0x1000000;
            this.tooltipIcon.setLayoutData((Object)gd);
            this.tooltipIcon.setToolTipText(tooltip);
            this.tooltipIcon.setBackground(this.text.getBackground());
        }
        this.defaultBackground = this.text.getBackground();
        this.textArea.setBackground(this.text.getBackground());
        this.enableAutoComplete(proposalProvider);
        this.buttonArea = new Composite((Composite)this, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.wrap = true;
        buttonLayout.marginBottom = 0;
        buttonLayout.marginTop = 0;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonLayout.spacing = 4;
        buttonLayout.pack = false;
        this.buttonArea.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.buttonArea.setLayoutData((Object)gd);
        this.clearButton = new Label((Composite)this, 0);
        this.clearButton.setBackground(this.getBackground());
        this.clearButton.setCursor(this.getDisplay().getSystemCursor(21));
        this.clearButton.setImage(SharedIcons.IMG_CLEAR);
        this.clearButton.setToolTipText(this.i18n.tr("Clear"));
        gd = new GridData();
        gd.verticalAlignment = 0x1000000;
        this.clearButton.setLayoutData((Object)gd);
        this.clearButton.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        if (showFilterCloseButton) {
            this.closeButton = new Label((Composite)this, 0);
            this.closeButton.setBackground(this.getBackground());
            this.closeButton.setCursor(this.getDisplay().getSystemCursor(21));
            this.closeButton.setImage(SharedIcons.IMG_CLOSE);
            this.closeButton.setToolTipText(this.i18n.tr("Close filter"));
            gd = new GridData();
            gd.verticalAlignment = 0x1000000;
            this.closeButton.setLayoutData((Object)gd);
            this.closeButton.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void enableAutoComplete(IContentProposalProvider proposalProvider) {
        if (proposalProvider == null) {
            return;
        }
        this.proposalAdapter = new ContentProposalAdapter((Control)this.text, (IControlContentAdapter)new TextContentAdapter(), proposalProvider, null, null);
        this.proposalAdapter.setPropagateKeys(true);
        this.proposalAdapter.setProposalAcceptanceStyle(3);
        this.proposalAdapter.addContentProposalListener((IContentProposalListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static boolean isStopCharacter(char ch) {
        return ch == ':' || ch == ',' || Character.isWhitespace(ch);
    }

    private void clearFilter() {
        if (!this.text.getText().equals("")) {
            this.text.setText("");
        }
        if (!this.autoApply) {
            this.callModifyListeners(this.lastModifyEvent);
        }
    }

    private void closeFilter() {
        if (this.closeAction != null) {
            this.closeAction.run();
        }
        if (this.closeCallback != null) {
            this.closeCallback.run();
        }
    }

    public void setAttributeList(String[] attributes) {
        for (Button b : this.attrButtons) {
            b.dispose();
        }
        this.attrButtons.clear();
        for (String attr : attributes) {
            Button b = new Button(this.buttonArea, 2);
            b.setText(attr);
            this.attrButtons.add(b);
            b.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        this.layout(true, true);
    }

    private void onAttrButtonSelection(Button b) {
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    private void callModifyListeners(ModifyEvent e) {
        for (ModifyListener l : this.modifyListeners) {
            l.modifyText(e);
        }
    }

    public String getText() {
        return this.text.getText();
    }

    public void setText(String value) {
        this.text.setText(value);
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    public void setCloseAction(Action closeAction) {
        this.closeAction = closeAction;
    }

    public void setCloseCallback(Runnable closeCallback) {
        this.closeCallback = closeCallback;
    }

    public boolean setFocus() {
        if (this.text.isDisposed()) {
            return false;
        }
        return this.text.setFocus();
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public boolean isAutoApply() {
        return this.autoApply;
    }

    public void setAutoApply(boolean autoApply) {
        this.autoApply = autoApply;
    }

    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int minLength) {
        this.minLength = minLength;
    }

    public void setTooltip(String tooltip) {
        if (this.tooltipIcon != null) {
            this.tooltipIcon.setToolTipText(tooltip);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.closeButton != null) {
            this.closeButton.setBackground(color);
        }
        if (this.clearButton != null) {
            this.clearButton.setBackground(color);
        }
    }
}

