/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.UUID;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentPolicy;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.EmbeddedProgressMonitor;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.modules.datacollection.dialogs.FilePermissionDialog;
import org.netxms.nxmc.modules.datacollection.views.PolicyEditorView;
import org.netxms.nxmc.modules.datacollection.widgets.AbstractPolicyEditor;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.FileDeliveryPolicy;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.FileDeliveryPolicyComparator;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.FileDeliveryPolicyContentProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.FileDeliveryPolicyLabelProvider;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.PathElement;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDeliveryPolicyEditor
extends AbstractPolicyEditor {
    private static final Logger logger = LoggerFactory.getLogger(FileDeliveryPolicyEditor.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_GUID = 1;
    public static final int COLUMN_DATE = 2;
    public static final int COLUMN_USER = 3;
    public static final int COLUMN_GROUP = 4;
    public static final int COLUMN_PERMISSIONS = 5;
    private SortableTreeViewer fileTree;
    private EmbeddedProgressMonitor progressMonitor;
    private Set<PathElement> rootElements = new HashSet();
    private Action actionAddRoot;
    private Action actionAddDirectory;
    private Action actionAddFile;
    private Action actionDelete;
    private Action actionRename;
    private Action actionUpdate;
    private Action actionEditPermissions;
    private Set<String> filesForDeletion = new HashSet();
    private Set<String> notSavedFiles = new HashSet();
    private boolean fileTransferInProgress = false;

    public FileDeliveryPolicyEditor(Composite parent, int style, AgentPolicy policy, PolicyEditorView view) {
        super(parent, style, policy, view);
        this.setLayout((Layout)new FormLayout());
        String[] columnNames = new String[]{"Name", "Guid", "Date", "User", "Group", "Permissions"};
        int[] columnWidths = new int[]{300, 300, 200, 150, 150, 200};
        this.fileTree = new SortableTreeViewer((Composite)this, columnNames, columnWidths, 0, 128, -1);
        this.fileTree.setContentProvider((IContentProvider)new FileDeliveryPolicyContentProvider());
        this.fileTree.setLabelProvider((IBaseLabelProvider)new FileDeliveryPolicyLabelProvider());
        this.fileTree.setComparator((ViewerComparator)new FileDeliveryPolicyComparator());
        this.fileTree.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.progressMonitor = new EmbeddedProgressMonitor((Composite)this, 0, false);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.fileTree.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.progressMonitor.setLayoutData((Object)fd);
        this.createActions();
        this.createPopupMenu();
        this.fileTree.setInput((Object)this.rootElements);
        this.updateControlFromPolicy();
    }

    private void createActions() {
        this.actionAddRoot = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddDirectory = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAddFile = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRename = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUpdate = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditPermissions = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.fileTree.getControl());
        this.fileTree.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.isEmpty()) {
            manager.add((IAction)this.actionAddRoot);
        } else if (selection.size() == 1) {
            PathElement e = (PathElement)selection.getFirstElement();
            if (e.isFile()) {
                manager.add((IAction)this.actionUpdate);
            } else {
                manager.add((IAction)this.actionAddDirectory);
                manager.add((IAction)this.actionAddFile);
            }
            manager.add((IAction)this.actionRename);
            manager.add((IAction)this.actionEditPermissions);
            manager.add((IAction)this.actionDelete);
        } else {
            manager.add((IAction)this.actionDelete);
        }
    }

    private void enableFileTransferMode(boolean enable) {
        this.fileTransferInProgress = enable;
        this.actionAddFile.setEnabled(!enable);
        this.view.enableSaveAction(!enable);
        this.progressMonitor.setVisible(enable);
        ((FormData)this.fileTree.getControl().getLayoutData()).bottom = enable ? new FormAttachment((Control)this.progressMonitor, 0, 128) : new FormAttachment(100, 0);
        this.layout(true, true);
    }

    public void updateControlFromPolicy() {
        HashSet<PathElement> newElementSet = new HashSet<PathElement>();
        try {
            FileDeliveryPolicy policyData = FileDeliveryPolicy.createFromXml((String)this.policy.getContent());
            newElementSet.addAll(Arrays.asList(policyData.elements));
        }
        catch (Exception e) {
            logger.error("Cannot parse file delivery policy XML", (Throwable)e);
        }
        this.checkForMissingElements(this.rootElements, newElementSet, false);
        this.checkForMissingElements(newElementSet, this.rootElements, true);
        this.fileTree.refresh(true);
    }

    private void checkForMissingElements(Set<PathElement> newElements, Set<PathElement> originalElements, boolean createMissing) {
        Iterator<PathElement> iter = newElements.iterator();
        while (iter.hasNext()) {
            PathElement newElement = iter.next();
            PathElement originalElement = null;
            for (PathElement e : originalElements) {
                if (!newElement.getName().equals(e.getName())) continue;
                originalElement = e;
                break;
            }
            if (originalElement == null) {
                if (createMissing) {
                    this.fileTree.refresh((Object)newElement, true);
                    originalElements.add(newElement);
                    continue;
                }
                iter.remove();
                continue;
            }
            if (newElement.isFile() != originalElement.isFile() && createMissing) {
                originalElements.add(newElement);
                continue;
            }
            if (newElement.isFile()) continue;
            this.checkForMissingElements(newElement.getChildrenSet(), originalElement.getChildrenSet(), createMissing);
        }
    }

    public void updatePolicyFromControl() {
        FileDeliveryPolicy data = new FileDeliveryPolicy();
        data.elements = this.rootElements.toArray(new PathElement[this.rootElements.size()]);
        try {
            this.policy.setContent(data.createXml());
        }
        catch (Exception e) {
            logger.error("Error serializing file delivery policy", (Throwable)e);
        }
    }

    private void addDirectory() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1 || ((PathElement)selection.getFirstElement()).isFile()) {
            return;
        }
        this.addElement((PathElement)selection.getFirstElement());
    }

    private void addFile() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1 || ((PathElement)selection.getFirstElement()).isFile()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 4098);
        String selectionFolder = dlg.open();
        if (selectionFolder == null) {
            return;
        }
        ArrayList<PathElement> uploadList = new ArrayList<PathElement>();
        for (String name : dlg.getFileNames()) {
            File f;
            File file = f = name.charAt(0) == File.separatorChar ? new File(name) : new File(new File(selectionFolder).getParentFile(), name);
            if (f.exists()) {
                PathElement e = ((PathElement)selection.getFirstElement()).findChild(f.getName());
                if (e != null) {
                    if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"File overwrite confirmation", (String)("File with " + f.getName() + " already exist. Do you want to overwrite it?"))) continue;
                    e.setFile(f);
                } else {
                    e = new PathElement((PathElement)selection.getFirstElement(), f.getName(), f, UUID.randomUUID(), new Date());
                    this.notSavedFiles.add(e.getGuid().toString());
                }
                uploadList.add(e);
                continue;
            }
            logger.info("File does not exist: " + name);
        }
        if (!uploadList.isEmpty()) {
            this.fileTree.refresh();
            this.fireModifyListeners();
            this.enableFileTransferMode(true);
            logger.info("FileDeliveryPolicyEditor: " + uploadList.size() + " files to upload");
            NXCSession session = Registry.getSession();
            new /* Unavailable Anonymous Inner Class!! */.start((IProgressMonitor)this.progressMonitor);
        }
    }

    private void deleteFile(String name) {
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void updateFile() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1 || !((PathElement)selection.getFirstElement()).isFile()) {
            return;
        }
        FileDialog dlg = new FileDialog(this.getShell(), 4096);
        String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        File file = new File(fileName);
        if (!file.exists()) {
            return;
        }
        this.enableFileTransferMode(true);
        PathElement e = (PathElement)selection.getFirstElement();
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start((IProgressMonitor)this.progressMonitor);
    }

    private void addElement(PathElement parent) {
        InputDialog dlg = new InputDialog(this.getShell(), parent == null ? "New root directory" : "New directory", "Enter name for new directory", "", (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() != 0) {
            return;
        }
        PathElement e = new PathElement(parent, dlg.getValue());
        if (parent == null) {
            this.rootElements.add(e);
            this.fileTree.refresh(true);
        } else {
            this.fileTree.refresh();
        }
        this.fireModifyListeners();
    }

    private void renameElement() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        PathElement element = (PathElement)selection.getFirstElement();
        InputDialog dlg = new InputDialog(this.getShell(), element.isFile() ? "Rename file" : "Rename directory", "Enter new name", element.getName(), (IInputValidator)new /* Unavailable Anonymous Inner Class!! */);
        if (dlg.open() != 0) {
            return;
        }
        ((PathElement)selection.getFirstElement()).updateCreationTime();
        if (element.getParent() == null) {
            this.rootElements.remove(element);
            element.setName(dlg.getValue());
            this.rootElements.add(element);
            this.fileTree.refresh();
        } else {
            element.setName(dlg.getValue());
            this.fileTree.update((Object)element, null);
        }
        this.fireModifyListeners();
    }

    private void changePermissions() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        PathElement element = (PathElement)selection.getFirstElement();
        FilePermissionDialog dlg = new FilePermissionDialog(this.getShell(), element.getPermissions().intValue(), element.getOwner(), element.getOwnerGroup());
        if (dlg.open() != 0) {
            return;
        }
        element.setPermissions(Integer.valueOf(dlg.getPermissions()));
        element.setOwner(dlg.getOwner());
        element.setOwnerGroup(dlg.getGroup());
        this.fileTree.update((Object)element, null);
        this.fireModifyListeners();
    }

    private void deleteElements() {
        ITreeSelection selection = this.fileTree.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getShell(), (String)"Delete confirmation", (String)"Delete selected files?")) {
            return;
        }
        for (Object o : selection.toList()) {
            PathElement element = (PathElement)o;
            if (element.isFile()) {
                this.deleteFiles(element);
            }
            if (element.getParent() == null) {
                this.rootElements.remove(o);
                continue;
            }
            element.remove();
        }
        this.fileTree.refresh(true);
        this.fireModifyListeners();
    }

    private void deleteFiles(PathElement element) {
        if (element.isFile()) {
            this.filesForDeletion.add(element.getGuid().toString());
        } else {
            for (PathElement el : element.getChildren()) {
                this.deleteFiles(el);
            }
        }
    }

    public void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionAddRoot);
    }

    public void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionAddRoot);
    }

    public String isSaveAllowed() {
        return this.fileTransferInProgress ? "File transfer is in progress" : null;
    }

    public void onSave() {
        this.notSavedFiles.clear();
        for (String name : this.filesForDeletion) {
            this.deleteFile(name);
        }
        this.filesForDeletion.clear();
    }

    public void onDiscard() {
        for (String name : this.notSavedFiles) {
            this.deleteFile(name);
        }
        this.notSavedFiles.clear();
    }
}

