/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledSpinner;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.dashboards.DashboardElementPropertiesManager;
import org.netxms.nxmc.modules.dashboards.ElementCreationHandler;
import org.netxms.nxmc.modules.dashboards.ElementCreationMenuManager;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfig;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementConfigFactory;
import org.netxms.nxmc.modules.dashboards.config.DashboardElementLayout;
import org.netxms.nxmc.modules.dashboards.dialogs.EditElementJsonDlg;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.helpers.DashboardElementsLabelProvider;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class DashboardElements
extends ObjectPropertyPage {
    private static final Logger logger = LoggerFactory.getLogger(DashboardElements.class);
    private final I18n i18n = LocalizationHelper.getI18n(DashboardElements.class);
    public static final int COLUMN_TYPE = 0;
    public static final int COLUMN_SPAN = 1;
    public static final int COLUMN_HEIGHT = 2;
    public static final int COLUMN_NARROW_SCREEN = 3;
    public static final int COLUMN_TITLE = 4;
    private Dashboard dashboard;
    private LabeledSpinner columnCount;
    private Button checkScrollable;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button editJsonButton;
    private Button duplicateButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private List<DashboardElement> elements;

    public DashboardElements(AbstractObject object) {
        super(LocalizationHelper.getI18n(DashboardElements.class).tr("Dashboard Elements"), object);
    }

    public String getId() {
        return "dashboard-elements";
    }

    public boolean isVisible() {
        return this.object instanceof Dashboard;
    }

    public int getPriority() {
        return 10;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.dashboard = (Dashboard)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.columnCount = new LabeledSpinner(dialogArea, 0);
        this.columnCount.setLabel(this.i18n.tr("Number of columns"));
        this.columnCount.setRange(1, 128);
        this.columnCount.setSelection(this.dashboard.getNumColumns());
        this.columnCount.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.checkScrollable = new Button(dialogArea, 32);
        this.checkScrollable.setText("&Scrollable content");
        this.checkScrollable.setSelection(this.dashboard.isScrollable());
        this.checkScrollable.setLayoutData((Object)new GridData(16384, 128, true, false));
        String[] columnNames = new String[]{this.i18n.tr("Type"), this.i18n.tr("Span"), this.i18n.tr("Height"), this.i18n.tr("Narrow screen"), this.i18n.tr("Title")};
        int[] columnWidths = new int[]{150, 60, 90, 100, 300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.disableSorting();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new DashboardElementsLabelProvider());
        this.elements = DashboardElements.copyElements((List)this.dashboard.getElements());
        this.viewer.setInput((Object)this.elements.toArray());
        GridData gd = new GridData();
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 0;
        gd.horizontalSpan = 2;
        this.viewer.getControl().setLayoutData((Object)gd);
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        this.upButton = new Button(leftButtons, 8);
        this.upButton.setText(this.i18n.tr("&Up"));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downButton = new Button(leftButtons, 8);
        this.downButton.setText(this.i18n.tr("Dow&n"));
        this.downButton.setEnabled(false);
        this.downButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gd);
        this.addButton = new Button(rightButtons, 8);
        this.addButton.setText(this.i18n.tr("&Add \u25be"));
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(rightButtons, 8);
        this.editButton.setText(this.i18n.tr("&Edit..."));
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editJsonButton = new Button(rightButtons, 8);
        this.editJsonButton.setText(this.i18n.tr("Edit &JSON..."));
        this.editJsonButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.duplicateButton = new Button(rightButtons, 8);
        this.duplicateButton.setText(this.i18n.tr("Du&plicate"));
        this.duplicateButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(rightButtons, 8);
        this.deleteButton.setText(this.i18n.tr("&Delete"));
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private static List<DashboardElement> copyElements(List<DashboardElement> src) {
        ArrayList<DashboardElement> dst = new ArrayList<DashboardElement>(src.size());
        for (DashboardElement e : src) {
            dst.add(new DashboardElement(e));
        }
        return dst;
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.dashboard.getObjectId());
        md.setDashboardElements((Collection)this.elements);
        md.setColumnCount(this.columnCount.getSelection());
        md.setObjectFlags(this.checkScrollable.getSelection() ? 131072 : 0, 131072);
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    private void addNewElement() {
        Rectangle rect = this.addButton.getBounds();
        Point pt = new Point(rect.x, rect.y + rect.height);
        pt = this.addButton.getParent().toDisplay(pt);
        ElementCreationMenuManager menuManager = new ElementCreationMenuManager((ElementCreationHandler)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuManager.createContextMenu((Control)this.addButton);
        menu.setLocation(pt.x, pt.y);
        menu.setVisible(true);
    }

    private void editElement() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        DashboardElement element = (DashboardElement)selection.getFirstElement();
        DashboardElementConfig config = DashboardElementConfigFactory.create((DashboardElement)element);
        if (config != null) {
            try {
                Gson gson = new Gson();
                config.setLayout((DashboardElementLayout)gson.fromJson(element.getLayout(), DashboardElementLayout.class));
                if (!DashboardElementPropertiesManager.openElementPropertiesDialog((DashboardElementConfig)config, (Shell)this.getShell())) {
                    return;
                }
                element.setData(config.createJson());
                element.setLayout(gson.toJson((Object)config.getLayout()));
                this.viewer.update((Object)element, null);
            }
            catch (Exception e) {
                MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)String.format(this.i18n.tr("Internal error (%s)"), e.getLocalizedMessage()));
                logger.error("Internal error while opening dashboard element configuration editor", (Throwable)e);
            }
        } else {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)this.i18n.tr("Internal error (cannot parse element configuration)"));
        }
    }

    private void editElementJson() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        DashboardElement element = (DashboardElement)selection.getFirstElement();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Object json = gson.fromJson(element.getData(), Object.class);
        EditElementJsonDlg dlg = new EditElementJsonDlg(this.getShell(), gson.toJson(json));
        if (dlg.open() == 0) {
            element.setData(dlg.getValue());
            this.viewer.update((Object)element, null);
        }
    }

    private void duplicateElements() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        ArrayList<DashboardElement> newSelection = new ArrayList<DashboardElement>();
        for (Object o : selection.toList()) {
            DashboardElement e = new DashboardElement((DashboardElement)o);
            e.setIndex(this.elements.size());
            this.elements.add(e);
            newSelection.add(e);
        }
        this.viewer.setInput((Object)this.elements.toArray());
        this.viewer.setSelection((ISelection)new StructuredSelection(newSelection));
    }

    private void deleteElements() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        for (Object o : selection.toList()) {
            this.elements.remove(o);
        }
        this.viewer.setInput((Object)this.elements.toArray());
    }

    private void moveUp() {
        DashboardElement element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = (DashboardElement)selection.getFirstElement())) > 0) {
            Collections.swap(this.elements, index - 1, index);
            this.viewer.setInput((Object)this.elements.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }

    private void moveDown() {
        DashboardElement element;
        int index;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1 && (index = this.elements.indexOf(element = (DashboardElement)selection.getFirstElement())) < this.elements.size() - 1 && index >= 0) {
            Collections.swap(this.elements, index + 1, index);
            this.viewer.setInput((Object)this.elements.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element));
        }
    }
}

