/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.base.widgets.PasswordInputField;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class VNC
extends ObjectPropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(VNC.class);
    private AbstractNode node;
    private ObjectSelector vncProxy;
    private LabeledText vncPort;
    private PasswordInputField vncPassword;

    public VNC(AbstractObject object) {
        super(LocalizationHelper.getI18n(VNC.class).tr("VNC"), object);
    }

    public String getId() {
        return "communication.vnc";
    }

    public String getParentId() {
        return "communication";
    }

    public boolean isVisible() {
        return this.object instanceof AbstractNode;
    }

    protected Control createContents(Composite parent) {
        this.node = (AbstractNode)this.object;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.numColumns = 2;
        dialogArea.setLayout((Layout)dialogLayout);
        this.vncPort = new LabeledText(dialogArea, 0);
        this.vncPort.setLabel("Port");
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = WidgetHelper.getTextWidth((Control)this.vncPort, (String)"00000") * 2;
        this.vncPort.setLayoutData((Object)gd);
        this.vncPort.setText(Integer.toString(this.node.getVncPort()));
        this.vncPort.getTextControl().setTextLimit(5);
        this.vncPassword = new PasswordInputField(dialogArea, 0);
        this.vncPassword.setLabel(this.i18n.tr("Password"));
        this.vncPassword.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.vncPassword.setText(this.node.getVncPassword());
        this.vncProxy = new ObjectSelector(dialogArea, 0, true);
        this.vncProxy.setLabel(this.i18n.tr("Proxy"));
        this.vncProxy.setEmptySelectionName("<default>");
        this.vncProxy.setObjectId(this.node.getVncProxyId());
        this.vncProxy.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (isApply) {
            this.setValid(false);
        }
        try {
            md.setVncPort(Integer.valueOf(Integer.parseInt(this.vncPort.getText(), 10)));
        }
        catch (NumberFormatException e) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)this.i18n.tr("Warning"), (String)this.i18n.tr("Please enter valid VNC port number"));
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        md.setVncProxy(Long.valueOf(this.vncProxy.getObjectId()));
        md.setVncPassword(this.vncPassword.getText());
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.vncProxy.setObjectId(0L);
        this.vncPassword.setText("");
        this.vncPort.setText("5900");
    }
}

