/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.nxmc.Memento;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.actions.ViewerProvider;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.views.ViewNotRestoredException;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.HardwareInventoryView;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.widgets.AbstractHardwareInventoryWidget;
import org.netxms.nxmc.modules.objects.widgets.EntityMibTreeViewer;
import org.netxms.nxmc.modules.objects.widgets.HardwareInventoryTable;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class HardwareInventoryView
extends ObjectView {
    private final I18n i18n = LocalizationHelper.getI18n(HardwareInventoryView.class);
    private DisplayMode displayMode = DisplayMode.AGENT;
    private AbstractHardwareInventoryWidget inventoryWidget;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopyDescription;
    private Action actionCopyModel;
    private Action actionCopySerial;
    private Action actionCollapseAll;
    private Action actionExpandAll;

    public HardwareInventoryView() {
        super(LocalizationHelper.getI18n(HardwareInventoryView.class).tr("Hardware Inventory"), ResourceManager.getImageDescriptor((String)"icons/object-views/hardware.png"), "objects.hardware-inventory", false);
    }

    public View cloneView() {
        HardwareInventoryView view = (HardwareInventoryView)super.cloneView();
        view.displayMode = this.displayMode;
        return view;
    }

    protected void postClone(View view) {
        super.postClone(view);
        this.refresh();
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && (((Node)context).hasAgent() || ((Node)context).isEntityMibSupported());
    }

    public int getPriority() {
        return 60;
    }

    protected void createContent(Composite parent) {
        this.inventoryWidget = this.displayMode == DisplayMode.AGENT ? new HardwareInventoryTable(parent, 0, (ObjectView)this) : new EntityMibTreeViewer(parent, 0, (ObjectView)this);
        this.createActions();
        this.createContextMenu();
    }

    private void createActions() {
        1 vp = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ViewerProvider)vp, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ViewerProvider)vp, false);
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyName = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyDescription = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyModel = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopySerial = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCollapseAll = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExpandAll = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        this.inventoryWidget.setViewerMenu(menuMgr);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopy);
        if (this.inventoryWidget.getNameColumnIndex() != -1) {
            manager.add((IAction)this.actionCopyName);
        }
        manager.add((IAction)this.actionCopyDescription);
        manager.add((IAction)this.actionCopyModel);
        manager.add((IAction)this.actionCopySerial);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IAction)this.actionExportAllToCsv);
        if (this.inventoryWidget.isTreeViewer()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionCollapseAll);
            manager.add((IAction)this.actionExpandAll);
        }
    }

    public void refresh() {
        this.inventoryWidget.refresh();
    }

    protected void onObjectChange(AbstractObject object) {
        this.inventoryWidget.clear();
        if (object == null) {
            return;
        }
        if (this.displayMode == DisplayMode.AGENT && !((Node)object).hasAgent()) {
            this.inventoryWidget.dispose();
            this.inventoryWidget = new EntityMibTreeViewer(this.getClientArea(), 0, (ObjectView)this);
            this.displayMode = DisplayMode.ENTITY_MIB;
            this.createContextMenu();
        } else if (this.displayMode == DisplayMode.ENTITY_MIB && !((Node)object).isEntityMibSupported()) {
            this.inventoryWidget.dispose();
            this.inventoryWidget = new HardwareInventoryTable(this.getClientArea(), 0, (ObjectView)this);
            this.displayMode = DisplayMode.AGENT;
            this.createContextMenu();
        }
        this.inventoryWidget.refresh();
    }

    public void saveState(Memento memento) {
        super.saveState(memento);
        memento.set("displayMode", this.displayMode.toString());
    }

    public void restoreState(Memento memento) throws ViewNotRestoredException {
        super.restoreState(memento);
        this.displayMode = DisplayMode.valueOf((String)memento.getAsString("displayMode"));
    }
}

