/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views.elements;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.LinkLayerDiscoveryProtocol;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectIcons;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.objects.views.elements.OverviewPageElement;
import org.netxms.nxmc.modules.objects.widgets.helpers.DecoratingObjectLabelProvider;
import org.xnap.commons.i18n.I18n;

public class Connection
extends OverviewPageElement {
    private final I18n i18n = LocalizationHelper.getI18n(Connection.class);
    private NXCSession session = Registry.getSession();
    private CLabel nodeLabel;
    private CLabel interfaceLabel;
    private CLabel protocolLabel;
    private DecoratingObjectLabelProvider labelProvider;
    private Image interfaceIcon;
    private Image nodeIcon;

    public Connection(Composite parent, OverviewPageElement anchor, ObjectView objectView) {
        super(parent, anchor, objectView);
    }

    protected Control createClientArea(Composite parent) {
        this.labelProvider = new DecoratingObjectLabelProvider();
        parent.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        ObjectIcons objectIcons = (ObjectIcons)Registry.getSingleton(ObjectIcons.class);
        this.interfaceIcon = objectIcons.getImage(3);
        this.nodeIcon = objectIcons.getImage(2);
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        area.setLayout((Layout)layout);
        area.setBackground(parent.getDisplay().getSystemColor(25));
        this.nodeLabel = new CLabel(area, 0);
        this.nodeLabel.setBackground(area.getBackground());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.nodeLabel.setLayoutData((Object)gd);
        this.interfaceLabel = new CLabel(area, 0);
        this.interfaceLabel.setBackground(area.getBackground());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = 15;
        this.interfaceLabel.setLayoutData((Object)gd);
        this.protocolLabel = new CLabel(area, 0);
        this.protocolLabel.setBackground(area.getBackground());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalIndent = 15;
        this.protocolLabel.setLayoutData((Object)gd);
        return area;
    }

    protected String getTitle() {
        return this.i18n.tr("Connection");
    }

    protected void onObjectChange() {
        LinkLayerDiscoveryProtocol peerDiscoveryProtocol;
        long peerInterfaceId;
        long peerNodeId;
        if (this.getObject() == null) {
            return;
        }
        if (this.getObject() instanceof Interface) {
            Interface iface = (Interface)this.getObject();
            peerNodeId = iface.getPeerNodeId();
            peerInterfaceId = iface.getPeerInterfaceId();
            peerDiscoveryProtocol = iface.getPeerDiscoveryProtocol();
        } else if (this.getObject() instanceof AccessPoint) {
            AccessPoint ap = (AccessPoint)this.getObject();
            peerNodeId = ap.getPeerNodeId();
            peerInterfaceId = ap.getPeerInterfaceId();
            peerDiscoveryProtocol = ap.getPeerDiscoveryProtocol();
        } else {
            peerNodeId = 0L;
            peerInterfaceId = 0L;
            peerDiscoveryProtocol = LinkLayerDiscoveryProtocol.UNKNOWN;
        }
        if (peerNodeId != 0L) {
            AbstractObject peer = this.session.findObjectById(peerNodeId);
            this.nodeLabel.setText((String)(peer != null ? peer.getObjectName() : "<" + peerNodeId + ">"));
            this.nodeLabel.setImage(peer != null ? this.labelProvider.getImage((Object)peer) : this.nodeIcon);
        } else {
            this.nodeLabel.setText(this.i18n.tr("N/A"));
        }
        if (peerInterfaceId != 0L && peerInterfaceId != peerNodeId) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        } else if (peerInterfaceId == peerNodeId) {
            this.interfaceLabel.setText("eth0");
            this.interfaceLabel.setImage(this.interfaceIcon);
            this.protocolLabel.setText(peerDiscoveryProtocol.toString());
        } else {
            this.interfaceLabel.setText(this.i18n.tr("N/A"));
            this.protocolLabel.setText("");
        }
    }

    public boolean isApplicableForObject(AbstractObject object) {
        return object instanceof Interface && ((Interface)object).getPeerNodeId() != 0L || object instanceof AccessPoint && ((AccessPoint)object).getPeerNodeId() != 0L;
    }
}

