/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.dialogs;

import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.DateTimeSelector;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class IssueTokenDialog
extends Dialog {
    private I18n i18n = LocalizationHelper.getI18n(IssueTokenDialog.class);
    private int userId;
    private DateTimeSelector expirationTime;
    private LabeledText description;
    private LabeledText token;

    public IssueTokenDialog(Shell parentShell, int userId) {
        super(parentShell);
        this.userId = userId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Issue Authentication Token"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.expirationTime = new DateTimeSelector(dialogArea, 0);
        this.expirationTime.setValue(new Date(System.currentTimeMillis() + 31536000000L));
        this.expirationTime.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.description = new LabeledText(dialogArea, 0);
        this.description.setLabel(this.i18n.tr("Description"));
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        this.description.setLayoutData((Object)gd);
        this.token = new LabeledText(dialogArea, 0, 2056);
        this.token.setLabel(this.i18n.tr("Issued token"));
        this.token.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button copyButton = new Button(dialogArea, 8);
        copyButton.setBackground(dialogArea.getBackground());
        copyButton.setImage(SharedIcons.IMG_COPY_TO_CLIPBOARD);
        copyButton.setToolTipText(this.i18n.tr("Copy token to clipboard"));
        gd = new GridData();
        gd.verticalAlignment = 1024;
        copyButton.setLayoutData((Object)gd);
        copyButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, this.i18n.tr("Issue"), true);
        this.createButton(parent, 1, this.i18n.tr("Cancel"), false);
    }

    protected void okPressed() {
        NXCSession session = Registry.getSession();
        String d = this.description.getText().trim();
        int v = (int)((this.expirationTime.getValue().getTime() - System.currentTimeMillis()) / 1000L);
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    static /* synthetic */ Button access$000(IssueTokenDialog x0, int x1) {
        return x0.getButton(x1);
    }

    static /* synthetic */ Button access$100(IssueTokenDialog x0, int x1) {
        return x0.getButton(x1);
    }

    static /* synthetic */ Button access$200(IssueTokenDialog x0, int x1) {
        return x0.getButton(x1);
    }
}

