/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.users.propertypages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.CertificateMappingMethod;
import org.netxms.client.constants.UserAuthenticationMethod;
import org.netxms.client.users.User;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.MessageAreaHolder;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.users.dialogs.TwoFactorAuthMethodEditDialog;
import org.netxms.nxmc.modules.users.propertypages.Authentication;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class Authentication
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(Authentication.class);
    private NXCSession session = Registry.getSession();
    private User user;
    private List<MethodBinding> twoFactorAuthMethodBindings;
    private Button checkDisabled;
    private Button checkChangePassword;
    private Button checkFixedPassword;
    private Button checkTokenOnlyAuth;
    private Button checkCloseSessions;
    private Combo comboAuthMethod;
    private Combo comboMappingMethod;
    private Text textMappingData;
    private TableViewer twoFactorAuthMethodList;

    public Authentication(User user, MessageAreaHolder messageArea) {
        super(LocalizationHelper.getI18n(Authentication.class).tr("Authentication"), messageArea);
        this.user = user;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Group groupFlags = new Group(dialogArea, 0);
        groupFlags.setText(this.i18n.tr("Account Options"));
        layout = new GridLayout();
        groupFlags.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupFlags.setLayoutData((Object)gd);
        this.checkDisabled = new Button((Composite)groupFlags, 32);
        this.checkDisabled.setText(this.i18n.tr("Account &disabled"));
        this.checkDisabled.setSelection(this.user.isDisabled());
        this.checkChangePassword = new Button((Composite)groupFlags, 32);
        this.checkChangePassword.setText(this.i18n.tr("User must &change password at next logon"));
        this.checkChangePassword.setSelection(this.user.isPasswordChangeNeeded());
        this.checkFixedPassword = new Button((Composite)groupFlags, 32);
        this.checkFixedPassword.setText(this.i18n.tr("User cannot change &password"));
        this.checkFixedPassword.setSelection(this.user.isPasswordChangeForbidden());
        this.checkTokenOnlyAuth = new Button((Composite)groupFlags, 32);
        this.checkTokenOnlyAuth.setText(this.i18n.tr("Allow only &token based authentication"));
        this.checkTokenOnlyAuth.setSelection((this.user.getFlags() & 0x400) != 0);
        this.checkCloseSessions = new Button((Composite)groupFlags, 32);
        this.checkCloseSessions.setText(this.i18n.tr("Close other &sessions after login"));
        this.checkCloseSessions.setSelection((this.user.getFlags() & 0x200) != 0);
        Group groupMethod = new Group(dialogArea, 0);
        groupMethod.setText(this.i18n.tr("Authentication Method"));
        layout = new GridLayout();
        layout.numColumns = 2;
        groupMethod.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupMethod.setLayoutData((Object)gd);
        Label label = new Label((Composite)groupMethod, 0);
        label.setText(this.i18n.tr("Authentication method:"));
        this.comboAuthMethod = new Combo((Composite)groupMethod, 12);
        this.comboAuthMethod.add(this.i18n.tr("Local password"));
        this.comboAuthMethod.add(this.i18n.tr("RADIUS password"));
        this.comboAuthMethod.add(this.i18n.tr("Certificate"));
        this.comboAuthMethod.add(this.i18n.tr("Certificate or local password"));
        this.comboAuthMethod.add(this.i18n.tr("Certificate or RADIUS password"));
        this.comboAuthMethod.add(this.i18n.tr("LDAP password"));
        this.comboAuthMethod.select(this.user.getAuthMethod().getValue());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboAuthMethod.setLayoutData((Object)gd);
        label = new Label((Composite)groupMethod, 0);
        label.setText(this.i18n.tr("Certificate mapping method:"));
        this.comboMappingMethod = new Combo((Composite)groupMethod, 12);
        this.comboMappingMethod.add(this.i18n.tr("Subject"));
        this.comboMappingMethod.add(this.i18n.tr("Public key"));
        this.comboMappingMethod.add(this.i18n.tr("Common name"));
        this.comboMappingMethod.add("Template ID");
        this.comboMappingMethod.select(this.user.getCertMappingMethod().getValue());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboMappingMethod.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        this.textMappingData = WidgetHelper.createLabeledText((Composite)groupMethod, (int)2052, (int)-1, (String)this.i18n.tr("Certificate mapping data"), (String)this.user.getCertMappingData(), (Object)gd);
        Group twoFactorAuth = new Group(dialogArea, 0);
        twoFactorAuth.setText(this.i18n.tr("Two-factor authentication methods"));
        layout = new GridLayout();
        layout.numColumns = 2;
        twoFactorAuth.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        twoFactorAuth.setLayoutData((Object)gd);
        this.twoFactorAuthMethodList = new TableViewer((Composite)twoFactorAuth, 67586);
        this.twoFactorAuthMethodList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.twoFactorAuthMethodList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.twoFactorAuthMethodList.setLabelProvider((IBaseLabelProvider)new /* Unavailable Anonymous Inner Class!! */);
        this.twoFactorAuthMethodList.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttons = new Composite((Composite)twoFactorAuth, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        gd = new GridData();
        gd.widthHint = 90;
        addButton.setLayoutData((Object)gd);
        addButton.setText(this.i18n.tr("&Add..."));
        addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button editButton = new Button(buttons, 8);
        gd = new GridData();
        gd.widthHint = 90;
        editButton.setLayoutData((Object)gd);
        editButton.setText(this.i18n.tr("&Edit..."));
        editButton.setEnabled(false);
        editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Button deleteButton = new Button(buttons, 8);
        gd = new GridData();
        gd.widthHint = 90;
        deleteButton.setLayoutData((Object)gd);
        deleteButton.setText(this.i18n.tr("&Delete"));
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.twoFactorAuthMethodList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.twoFactorAuthMethodList.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.twoFactorAuthMethodBindings = new ArrayList(this.user.getTwoFactorAuthMethodBindings().size());
        for (Map.Entry e : this.user.getTwoFactorAuthMethodBindings().entrySet()) {
            this.twoFactorAuthMethodBindings.add(new MethodBinding((String)e.getKey(), (Map)e.getValue()));
        }
        this.twoFactorAuthMethodList.setInput((Object)this.twoFactorAuthMethodBindings);
        return dialogArea;
    }

    private void addMethod() {
        HashSet<String> configuredMethods = new HashSet<String>();
        for (MethodBinding b : this.twoFactorAuthMethodBindings) {
            configuredMethods.add(b.name);
        }
        TwoFactorAuthMethodEditDialog dlg = new TwoFactorAuthMethodEditDialog(this.getShell(), null, null, configuredMethods);
        if (dlg.open() != 0) {
            return;
        }
        for (MethodBinding b : this.twoFactorAuthMethodBindings) {
            if (!b.name.equals(dlg.getName())) continue;
            MessageDialogHelper.openError((Shell)this.getShell(), (String)this.i18n.tr("Error"), (String)String.format(this.i18n.tr("Two-factor authentication method %s already configured"), b.name));
            return;
        }
        this.twoFactorAuthMethodBindings.add(new MethodBinding(dlg.getName(), dlg.getConfiguration()));
        this.twoFactorAuthMethodList.refresh();
    }

    private void editMethod() {
        IStructuredSelection selection = this.twoFactorAuthMethodList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        MethodBinding b = (MethodBinding)selection.getFirstElement();
        TwoFactorAuthMethodEditDialog dlg = new TwoFactorAuthMethodEditDialog(this.getShell(), b.name, b.configuration, null);
        if (dlg.open() != 0) {
            return;
        }
        b.configuration = dlg.getConfiguration();
        this.twoFactorAuthMethodList.refresh();
    }

    protected boolean applyChanges(boolean isApply) {
        int flags = 0;
        if (this.checkDisabled.getSelection()) {
            flags |= 4;
        }
        if (this.checkChangePassword.getSelection()) {
            flags |= 8;
        }
        if (this.checkFixedPassword.getSelection()) {
            flags |= 0x10;
        }
        if (this.checkTokenOnlyAuth.getSelection()) {
            flags |= 0x400;
        }
        if (this.checkCloseSessions.getSelection()) {
            flags |= 0x200;
        }
        this.user.setFlags(flags |= this.user.getFlags() & 0x80);
        this.user.setAuthMethod(UserAuthenticationMethod.getByValue((int)this.comboAuthMethod.getSelectionIndex()));
        this.user.setCertMappingMethod(CertificateMappingMethod.getByValue((int)this.comboMappingMethod.getSelectionIndex()));
        this.user.setCertMappingData(this.textMappingData.getText());
        HashMap<String, Map> bindings = new HashMap<String, Map>(this.twoFactorAuthMethodBindings.size());
        for (MethodBinding b : this.twoFactorAuthMethodBindings) {
            bindings.put(b.name, b.configuration);
        }
        this.user.setTwoFactorAuthMethodBindings(bindings);
        if (isApply) {
            this.setMessage(null);
            this.setValid(false);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

