/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.ui.eclipse.charts.api.DataSeries;
import org.netxms.ui.eclipse.charts.api.GaugeColorMode;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.charts.widgets.GenericGauge;
import org.netxms.ui.eclipse.compatibility.GraphItem;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class CircularGauge
extends GenericGauge {
    private static final int EXTRA_MARGIN = 10;
    private Font[] legendFonts = null;
    private Font[] valueFonts = null;

    public CircularGauge(Chart parent) {
        super(parent);
    }

    @Override
    protected void createFonts() {
        String fontName = this.chart.getConfiguration().getFontName();
        this.legendFonts = new Font[16];
        int i = 0;
        while (i < this.legendFonts.length) {
            this.legendFonts[i] = new Font((Device)this.getDisplay(), fontName, i + 6, 0);
            ++i;
        }
        this.valueFonts = new Font[16];
        i = 0;
        while (i < this.valueFonts.length) {
            this.valueFonts[i] = new Font((Device)this.getDisplay(), fontName, i * 2 + 6, 1);
            ++i;
        }
    }

    @Override
    protected void disposeFonts() {
        int i;
        if (this.legendFonts != null) {
            i = 0;
            while (i < this.legendFonts.length) {
                this.legendFonts[i].dispose();
                ++i;
            }
        }
        if (this.valueFonts != null) {
            i = 0;
            while (i < this.valueFonts.length) {
                this.valueFonts[i].dispose();
                ++i;
            }
        }
    }

    @Override
    protected void renderElement(GC gc, ChartConfiguration configuration, Object renderData, GraphItem dci, DataSeries data, int x, int y, int w, int h, int index) {
        Rectangle rect = new Rectangle(x + 5 + 10, y + 5 + 10, w - 10 - 20, h - 10 - 20);
        gc.setAntialias(1);
        if (configuration.areLabelsVisible() && !configuration.areLabelsInside()) {
            gc.setFont(null);
            rect.height -= gc.textExtent((String)"MMM").y + 4;
        }
        if (rect.height > rect.width) {
            rect.y += (rect.height - rect.width) / 2;
            rect.height = rect.width;
        } else {
            rect.x += (rect.width - rect.height) / 2;
            rect.width = rect.height;
        }
        int cx = rect.x + rect.width / 2 + 1;
        int cy = rect.y + rect.height / 2 + 1;
        double maxValue = configuration.getMaxYScaleValue();
        double minValue = configuration.getMinYScaleValue();
        double value = data.getCurrentValue();
        GaugeColorMode colorMode = GaugeColorMode.getByValue(configuration.getGaugeColorMode());
        if (colorMode == GaugeColorMode.ZONE) {
            double angleValue = (maxValue - minValue) / 360.0;
            double startAngle = 90.0;
            double stopAngle = 90.0 - (value - minValue) / (maxValue - minValue) * 360.0;
            startAngle = this.drawZone(gc, rect, startAngle, stopAngle, minValue, configuration.getLeftRedZone(), angleValue, RED_ZONE_COLOR);
            startAngle = this.drawZone(gc, rect, startAngle, stopAngle, configuration.getLeftRedZone(), configuration.getLeftYellowZone(), angleValue, YELLOW_ZONE_COLOR);
            startAngle = this.drawZone(gc, rect, startAngle, stopAngle, configuration.getLeftYellowZone(), configuration.getRightYellowZone(), angleValue, GREEN_ZONE_COLOR);
            startAngle = this.drawZone(gc, rect, startAngle, stopAngle, configuration.getRightYellowZone(), configuration.getRightRedZone(), angleValue, YELLOW_ZONE_COLOR);
            startAngle = this.drawZone(gc, rect, startAngle, stopAngle, configuration.getRightRedZone(), maxValue, angleValue, RED_ZONE_COLOR);
            gc.setBackground(this.chart.getColorFromPreferences("Chart.Colors.EmptySection"));
            gc.fillArc(rect.x, rect.y, rect.width, rect.height, 90, -(-270 - (int)Math.ceil(startAngle)));
        } else {
            switch (colorMode) {
                case CUSTOM: {
                    gc.setBackground(this.chart.getColorCache().create(this.chart.getPaletteEntry(0).getRGBObject()));
                    break;
                }
                case DATA_SOURCE: {
                    gc.setBackground(this.chart.getColorCache().create(this.getDataSourceColor(dci, index)));
                    break;
                }
                case THRESHOLD: {
                    gc.setBackground(StatusDisplayInfo.getStatusColor((Severity)data.getActiveThresholdSeverity()));
                    break;
                }
                default: {
                    gc.setBackground(this.getDisplay().getSystemColor(26));
                }
            }
            int angularSize = value < minValue ? 0 : (value > maxValue ? 360 : (int)Math.round((value - minValue) / (maxValue - minValue) * 360.0));
            gc.fillArc(rect.x, rect.y, rect.width, rect.height, 90, -angularSize);
            gc.setBackground(this.chart.getColorFromPreferences("Chart.Colors.EmptySection"));
            gc.fillArc(rect.x, rect.y, rect.width, rect.height, 90, 360 - angularSize);
        }
        gc.setBackground(this.chart.getColorFromPreferences("Chart.Colors.PlotArea"));
        int width = rect.width / 7;
        gc.fillArc(rect.x + width, rect.y + width, rect.width - width * 2, rect.height - width * 2, 0, 360);
        int innerBoxSize = rect.width - rect.width / 6;
        if (configuration.areLabelsVisible()) {
            gc.setFont(configuration.areLabelsInside() ? WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.legendFonts, (String)"XXXXXXXXXXXXXXXXXXXXXXXX", (int)innerBoxSize, (int)innerBoxSize) : null);
            Point ext = gc.textExtent(dci.getDescription());
            gc.setForeground(this.chart.getColorFromPreferences("Chart.Colors.Legend"));
            if (configuration.areLabelsInside()) {
                if (ext.x <= innerBoxSize && ext.y <= innerBoxSize) {
                    gc.drawText(dci.getDescription(), cx - ext.x / 2, cy, 1);
                }
            } else {
                gc.drawText(dci.getDescription(), rect.x + (rect.width - ext.x) / 2, rect.y + rect.height + 4, true);
            }
        }
        String valueText = this.getValueAsDisplayString(dci, data);
        gc.setFont(WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.valueFonts, (String)"00000000", (int)innerBoxSize, (int)innerBoxSize));
        Point ext = gc.textExtent(valueText);
        if (ext.x <= innerBoxSize && ext.y <= innerBoxSize) {
            switch (colorMode) {
                case CUSTOM: {
                    gc.setForeground(this.chart.getColorCache().create(this.chart.getPaletteEntry(0).getRGBObject()));
                    break;
                }
                case DATA_SOURCE: {
                    gc.setForeground(this.chart.getColorCache().create(this.getDataSourceColor(dci, index)));
                    break;
                }
                case THRESHOLD: {
                    gc.setForeground(StatusDisplayInfo.getStatusColor((Severity)data.getActiveThresholdSeverity()));
                    break;
                }
                case ZONE: {
                    if (data.getCurrentValue() <= configuration.getLeftRedZone() || data.getCurrentValue() >= configuration.getRightRedZone()) {
                        gc.setForeground(this.chart.getColorCache().create(RED_ZONE_COLOR));
                        break;
                    }
                    if (data.getCurrentValue() <= configuration.getLeftYellowZone() || data.getCurrentValue() >= configuration.getRightYellowZone()) {
                        gc.setForeground(this.chart.getColorCache().create(YELLOW_ZONE_COLOR));
                        break;
                    }
                    gc.setForeground(this.chart.getColorCache().create(GREEN_ZONE_COLOR));
                    break;
                }
                default: {
                    gc.setForeground(this.chart.getColorFromPreferences("Chart.Colors.DialScale"));
                }
            }
            if (configuration.areLabelsInside()) {
                gc.drawText(valueText, cx - ext.x / 2, cy - ext.y, 1);
            } else {
                gc.drawText(valueText, cx - ext.x / 2, cy - ext.y / 2, 1);
            }
        }
    }

    private double drawZone(GC gc, Rectangle rect, double startAngle, double stopAngle, double minValue, double maxValue, double angleValue, RGB color) {
        if (minValue >= maxValue || startAngle <= stopAngle) {
            return startAngle;
        }
        double angle = (maxValue - minValue) / angleValue;
        if (angle <= 0.0) {
            return startAngle;
        }
        if (startAngle - angle < stopAngle) {
            angle = startAngle - stopAngle;
        }
        gc.setBackground(this.chart.getColorCache().create(color));
        gc.fillArc(rect.x, rect.y, rect.width, rect.height, (int)Math.ceil(startAngle), (int)(-Math.ceil(angle)));
        return startAngle - angle;
    }
}

