/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.widgets.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;

public class NXSLProposalProcessor
implements IContentAssistProcessor {
    private static final int FUNCTION = 0;
    private static final int GLOBAL_VARIABLE = 1;
    private static final int CONSTANT = 3;
    private static final String[] BUILTIN_SYSTEM_VARIABLES = new String[]{"$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9"};
    private static final String[] BUILTIN_FUNCTIONS = new String[]{"abs", "ceil", "classof", "d2x", "exit", "exp", "floor", "format", "gmtime", "index", "left", "length", "localtime", "log", "log10", "lower", "ltrim", "map", "max", "min", "pow", "right", "rindex", "round", "rtrim", "sleep", "strftime", "substr", "time", "trace", "trim", "typeof", "upper", "AddrInRange", "AddrInSubnet", "ArrayToString", "BindObject", "CreateContainer", "CreateSNMPTransport", "FindDCIByDescription", "FindDCIByName", "FindNodeObject", "FindObject", "FindSituation", "GetAvgDCIValue", "GetConfigurationVariable", "GetCustomAttribute", "GetDCIObject", "GetDCIValue", "GetDCIValueByDescription", "GetDCIValueByName", "GetEventParameter", "GetInterfaceName", "GetInterfaceObject", "GetMaxDCIValue", "GetMinDCIValue", "GetNodeInterfaces", "GetNodeParents", "GetNodeTemplates", "GetObjectChildren", "GetObjectParents", "GetSituationAttribute", "PostEvent", "RemoveContainer", "RenameObject", "SetCustomAttribute", "SetEventParameter", "SecondsToUptime", "SNMPGet", "SNMPGetValue", "SNMPSet", "SNMPWalk", "UnbindObject"};
    private static final String[] BUILTIN_CONSTANTS = new String[]{"null", "true", "false"};
    private ScriptEditor scriptEditor;

    public NXSLProposalProcessor(ScriptEditor scriptEditor) {
        this.scriptEditor = scriptEditor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String content = viewer.getTextWidget().getText(Math.max(0, offset - 64), offset - 1);
        StringBuilder sb = new StringBuilder();
        int i = content.length() - 1;
        while (i >= 0) {
            char ch = content.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) break;
            sb.insert(0, ch);
            --i;
        }
        String prefix = sb.toString();
        ArrayList<ICompletionProposal> list = new ArrayList<ICompletionProposal>();
        this.addProposals(list, prefix, offset, 1, BUILTIN_SYSTEM_VARIABLES);
        this.addProposals(list, prefix, offset, 0, BUILTIN_FUNCTIONS);
        this.addProposals(list, prefix, offset, 3, BUILTIN_CONSTANTS);
        this.addProposals(list, prefix, offset, 1, this.scriptEditor.getVariables());
        this.addProposals(list, prefix, offset, 0, this.scriptEditor.getFunctions());
        this.addProposals(list, prefix, offset, 3, this.scriptEditor.getConstants());
        return list.toArray(new ICompletionProposal[list.size()]);
    }

    private void addProposals(List<ICompletionProposal> props, String prefix, int offset, int type, String[] texts) {
        String[] stringArray = texts;
        int n = texts.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.startsWith(prefix)) {
                props.add((ICompletionProposal)new CompletionProposal(s, offset - prefix.length(), prefix.length(), s.length(), this.scriptEditor.getProposalIcon(type), s, null, null));
            }
            ++n2;
        }
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'$'};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return "No completion proposals";
    }
}

