/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.DashboardGroup;
import org.netxms.client.objects.DashboardRoot;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.CreateObjectDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class CreateDashboardGroup
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private long parentId = -1L;

    public void run(IAction action) {
        final CreateObjectDialog dlg = new CreateObjectDialog(this.window.getShell(), "Create dashboard group");
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Create dashboard group", this.part, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCObjectCreationData cd = new NXCObjectCreationData(36, dlg.getObjectName(), CreateDashboardGroup.this.parentId);
                cd.setObjectAlias(dlg.getObjectAlias());
                session.createObject(cd);
            }

            protected String getErrorMessage() {
                return String.format("Cannot create dashboard group object %s", dlg.getObjectName());
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object object;
        this.parentId = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((object = ((IStructuredSelection)selection).getFirstElement()) instanceof DashboardGroup || object instanceof DashboardRoot ? ((AbstractObject)object).getObjectId() : -1L) : -1L;
        action.setEnabled(this.parentId != -1L);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }
}

