/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.client.constants.ColumnFilterSetOperation;
import org.netxms.client.log.ColumnFilter;
import org.netxms.client.log.LogColumn;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.logviewer.widgets.AlarmHDStateConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.AlarmStateConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.CompletionStatusConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.ConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.EventConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.EventOriginConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.FilterBuilder;
import org.netxms.ui.eclipse.logviewer.widgets.IntegerConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.ObjectConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.SeverityConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.TextConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.TimestampConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.UserConditionEditor;
import org.netxms.ui.eclipse.logviewer.widgets.ZoneConditionEditor;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class ColumnFilterEditor
extends DashboardComposite {
    private LogColumn column;
    private FilterBuilder filterBuilder;
    private List<ConditionEditor> conditions = new ArrayList<ConditionEditor>();
    private ColumnFilterSetOperation booleanOperation = ColumnFilterSetOperation.OR;

    public ColumnFilterEditor(Composite parent, LogColumn column, ColumnFilterSetOperation operation, final Runnable deleteHandler) {
        super(parent, 2048);
        this.column = column;
        this.booleanOperation = operation;
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        Composite header = new Composite((Composite)this, 0);
        header.setBackground(this.getBackground());
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 5;
        header.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        header.setLayoutData((Object)gd);
        Label title = new Label(header, 0);
        title.setText(column.getDescription());
        title.setBackground(header.getBackground());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        title.setLayoutData((Object)gd);
        Composite buttons = new Composite(header, 0);
        buttons.setBackground(header.getBackground());
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.grabExcessHorizontalSpace = true;
        buttons.setLayoutData((Object)gd);
        Button radioAnd = new Button(buttons, 16);
        Messages.get();
        radioAnd.setText(Messages.ColumnFilterEditor_AndCondition);
        radioAnd.setBackground(buttons.getBackground());
        radioAnd.setSelection(this.booleanOperation == ColumnFilterSetOperation.AND);
        radioAnd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnFilterEditor.this.setBooleanOperation(ColumnFilterSetOperation.AND);
            }
        });
        Button radioOr = new Button(buttons, 16);
        Messages.get();
        radioOr.setText(Messages.ColumnFilterEditor_OrCondition);
        radioOr.setBackground(buttons.getBackground());
        radioOr.setSelection(this.booleanOperation == ColumnFilterSetOperation.OR);
        radioOr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnFilterEditor.this.setBooleanOperation(ColumnFilterSetOperation.OR);
            }
        });
        ImageHyperlink link = new ImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_ADD_OBJECT);
        link.setBackground(header.getBackground());
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ColumnFilterEditor.this.addCondition(null);
            }
        });
        link = new ImageHyperlink(header, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setBackground(header.getBackground());
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ColumnFilterEditor.this.dispose();
                deleteHandler.run();
            }
        });
    }

    private void setBooleanOperation(ColumnFilterSetOperation op) {
        String string;
        this.booleanOperation = op;
        if (op == ColumnFilterSetOperation.AND) {
            Messages.get();
            string = Messages.ColumnFilterEditor_And;
        } else {
            Messages.get();
            string = Messages.ColumnFilterEditor_Or;
        }
        String opName = string;
        int i = 1;
        while (i < this.conditions.size()) {
            this.conditions.get(i).setLogicalOperation(opName);
            ++i;
        }
    }

    private void addCondition(ColumnFilter initialFilter) {
        final ConditionEditor ce = this.createConditionEditor(initialFilter);
        ce.setDeleteHandler(new Runnable(){

            @Override
            public void run() {
                ColumnFilterEditor.this.conditions.remove((Object)ce);
                if (ColumnFilterEditor.this.conditions.size() > 0) {
                    ColumnFilterEditor.this.conditions.get(0).setLogicalOperation("");
                }
                ColumnFilterEditor.this.filterBuilder.updateLayout();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        ce.setLayoutData(gd);
        this.conditions.add(ce);
        if (this.conditions.size() > 1) {
            String string;
            if (this.booleanOperation == ColumnFilterSetOperation.AND) {
                Messages.get();
                string = Messages.ColumnFilterEditor_And;
            } else {
                Messages.get();
                string = Messages.ColumnFilterEditor_Or;
            }
            ce.setLogicalOperation(string);
        }
        this.filterBuilder.updateLayout();
    }

    private ConditionEditor createConditionEditor(ColumnFilter initialFilter) {
        ConditionEditor editor = switch (this.column.getType()) {
            case 8 -> new AlarmHDStateConditionEditor((Composite)this);
            case 7 -> new AlarmStateConditionEditor((Composite)this);
            case 13 -> new CompletionStatusConditionEditor((Composite)this);
            case 4 -> new EventConditionEditor((Composite)this);
            case 10 -> new EventOriginConditionEditor((Composite)this);
            case 6 -> new IntegerConditionEditor((Composite)this);
            case 2 -> new ObjectConditionEditor((Composite)this);
            case 1 -> new SeverityConditionEditor((Composite)this);
            case 5 -> new TimestampConditionEditor((Composite)this);
            case 3 -> new UserConditionEditor((Composite)this);
            case 9 -> new ZoneConditionEditor((Composite)this);
            default -> new TextConditionEditor((Composite)this);
        };
        editor.initialize(initialFilter);
        return editor;
    }

    public void attachFilterBuilder(FilterBuilder filterBuilder, ColumnFilter initialFilter) {
        this.filterBuilder = filterBuilder;
        if (initialFilter == null || initialFilter.getSubFilters() == null) {
            this.addCondition(null);
        } else {
            for (ColumnFilter f : initialFilter.getSubFilters()) {
                f.setOperation(f.getOperation());
                this.addCondition(f);
            }
        }
    }

    public ColumnFilter buildFilterTree() {
        if (this.conditions.size() == 0) {
            return null;
        }
        if (this.conditions.size() > 1) {
            ColumnFilter root = new ColumnFilter();
            root.setOperation(this.booleanOperation);
            for (ConditionEditor e : this.conditions) {
                ColumnFilter filter = e.createFilter();
                root.addSubFilter(filter);
            }
            return root;
        }
        return this.conditions.get(0).createFilter();
    }
}

