/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.ObjectUrl;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.objectmanager.dialogs.ObjectUrlEditDialog;
import org.netxms.ui.eclipse.objectmanager.propertypages.helpers.UrlListLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class ExternalResources
extends PropertyPage {
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    private AbstractObject object = null;
    private SortableTableViewer viewer;
    private Button moveUpButton;
    private Button moveDownButton;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private List<ObjectUrl> urls = null;
    private boolean modified = false;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractObject)this.getElement().getAdapter(AbstractObject.class);
        if (this.object == null) {
            return dialogArea;
        }
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{"URL", "Description"};
        int[] columnWidths = new int[]{300, 300};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new UrlListLabelProvider());
        this.urls = new ArrayList<ObjectUrl>(this.object.getUrls());
        this.viewer.setInput(this.urls);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttonsLeft = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gridData);
        this.moveUpButton = new Button(buttonsLeft, 8);
        this.moveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.moveUpButton.setLayoutData((Object)rd);
        this.moveUpButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExternalResources.this.moveSelection(true);
            }
        });
        this.moveDownButton = new Button(buttonsLeft, 8);
        this.moveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.moveDownButton.setLayoutData((Object)rd);
        this.moveDownButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExternalResources.this.moveSelection(false);
            }
        });
        Composite buttonsRight = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gridData);
        this.addButton = new Button(buttonsRight, 8);
        Messages.get();
        this.addButton.setText(Messages.CustomAttributes_Add);
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExternalResources.this.addUrl();
            }
        });
        this.editButton = new Button(buttonsRight, 8);
        Messages.get();
        this.editButton.setText(Messages.CustomAttributes_Modify);
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExternalResources.this.editUrl();
            }
        });
        this.deleteButton = new Button(buttonsRight, 8);
        Messages.get();
        this.deleteButton.setText(Messages.CustomAttributes_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                ExternalResources.this.deleteUrl();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ExternalResources.this.editButton.notifyListeners(13, new Event());
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)ExternalResources.this.viewer.getSelection();
                ExternalResources.this.moveUpButton.setEnabled(selection.size() == 1);
                ExternalResources.this.moveDownButton.setEnabled(selection.size() == 1);
                ExternalResources.this.editButton.setEnabled(selection.size() == 1);
                ExternalResources.this.deleteButton.setEnabled(selection.size() > 0);
            }
        });
        return dialogArea;
    }

    private void addUrl() {
        ObjectUrlEditDialog dlg = new ObjectUrlEditDialog(this.getShell(), null, null);
        if (dlg.open() != 0) {
            return;
        }
        this.urls.add(new ObjectUrl(this.urls.size(), dlg.getUrl(), dlg.getDescription()));
        this.viewer.refresh();
        this.modified = true;
    }

    private void editUrl() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ObjectUrl url = (ObjectUrl)selection.getFirstElement();
        ObjectUrlEditDialog dlg = new ObjectUrlEditDialog(this.getShell(), url.getUrl(), url.getDescription());
        if (dlg.open() != 0) {
            return;
        }
        int index = this.urls.indexOf(url);
        this.urls.set(index, new ObjectUrl(url.getId(), dlg.getUrl(), dlg.getDescription()));
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.urls.get(index)));
        this.modified = true;
    }

    private void deleteUrl() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        for (Object o : selection.toList()) {
            this.urls.remove(o);
        }
        int i = 0;
        while (i < this.urls.size()) {
            ObjectUrl u = this.urls.get(i);
            this.urls.set(i, new ObjectUrl(i, u.getUrl(), u.getDescription()));
            ++i;
        }
        this.viewer.refresh();
        this.modified = true;
    }

    private void moveSelection(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ObjectUrl url = (ObjectUrl)selection.getFirstElement();
        int index = this.urls.indexOf(url);
        if (index == 0 && up || index == this.urls.size() - 1 && !up) {
            return;
        }
        int swapIndex = up ? index - 1 : index + 1;
        ObjectUrl swapUrl = this.urls.get(swapIndex);
        this.urls.set(index, new ObjectUrl(index, swapUrl.getUrl(), swapUrl.getDescription()));
        this.urls.set(swapIndex, new ObjectUrl(index, url.getUrl(), url.getDescription()));
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)this.urls.get(swapIndex)));
        this.modified = true;
    }

    protected void applyChanges(final boolean isApply) {
        if (!this.modified) {
            return;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setUrls(new ArrayList<ObjectUrl>(this.urls));
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.CustomAttributes_JobName, null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                ExternalResources.this.modified = false;
            }

            protected String getErrorMessage() {
                return "Cannot update object's URL list";
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ExternalResources.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }
}

