/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.widgets;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.Activator;
import org.netxms.ui.eclipse.usermanager.dialogs.UserSelectionDialog;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class UserSelector
extends AbstractSelector {
    private int userId = 0;
    private Image imageUser;
    private Image imageGroup;

    public UserSelector(Composite parent, int style) {
        this(parent, style, 0);
    }

    public UserSelector(Composite parent, int style, int options) {
        super(parent, style, options);
        this.setText("<none>");
        this.imageUser = Activator.getImageDescriptor("icons/user.png").createImage();
        this.imageGroup = Activator.getImageDescriptor("icons/group.png").createImage();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UserSelector.this.imageUser.dispose();
                UserSelector.this.imageGroup.dispose();
            }
        });
    }

    protected void selectionButtonHandler() {
        UserSelectionDialog dlg = new UserSelectionDialog(this.getShell(), null);
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            long prevUserId = this.userId;
            AbstractUserObject[] users = dlg.getSelection();
            if (users.length > 0) {
                this.userId = users[0].getId();
                this.setText(users[0].getName());
                this.setImage(users[0] instanceof User ? this.imageUser : this.imageGroup);
            } else {
                this.userId = 0;
                this.setText("<none>");
                this.setImage(null);
            }
            if (prevUserId != (long)this.userId) {
                this.fireModifyListeners();
            }
        }
    }

    protected void clearButtonHandler() {
        if (this.userId == 0) {
            return;
        }
        this.userId = 0;
        this.setText("<none>");
        this.setImage(null);
        this.getTextControl().setToolTipText(null);
        this.fireModifyListeners();
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        if (this.userId == userId) {
            return;
        }
        this.userId = userId;
        if (userId != 0) {
            AbstractUserObject object = ConsoleSharedData.getSession().findUserDBObjectById(userId, () -> {
                AbstractUserObject updatedObject = ConsoleSharedData.getSession().findUserDBObjectById(userId, null);
                if (updatedObject != null) {
                    this.setText(updatedObject.getName());
                    this.setImage(updatedObject instanceof User ? this.imageUser : this.imageGroup);
                }
            });
            if (object != null) {
                this.setText(object.getName());
                this.setImage(object instanceof User ? this.imageUser : this.imageGroup);
            } else {
                this.setText("[" + userId + "]");
                this.setImage(null);
            }
        } else {
            this.setText("<none>");
            this.setImage(null);
        }
        this.fireModifyListeners();
    }

    protected String getSelectionButtonToolTip() {
        return "Select user";
    }
}

