/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.TitleConfigurator;
import org.netxms.ui.eclipse.dashboard.widgets.internal.EmbeddedDashboardConfig;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class EmbeddedDashboard
extends PropertyPage {
    private EmbeddedDashboardConfig config;
    private List<AbstractObject> dashboardObjects;
    private ObjectSelector contextObjectSelector;
    private TitleConfigurator title;
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;
    private Button upButton;
    private Button downButton;
    private Scale refreshIntervalScale;
    private Spinner refreshIntervalSpinner;

    protected Control createContents(Composite parent) {
        this.config = (EmbeddedDashboardConfig)this.getElement().getAdapter(EmbeddedDashboardConfig.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.title = new TitleConfigurator(dialogArea, this.config);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = layout.numColumns;
        this.title.setLayoutData(gd);
        this.contextObjectSelector = new ObjectSelector(dialogArea, 0, true, true);
        this.contextObjectSelector.setLabel("Context object");
        this.contextObjectSelector.setObjectClass(AbstractObject.class);
        this.contextObjectSelector.setObjectId(this.config.getContextObjectId());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = layout.numColumns;
        this.contextObjectSelector.setLayoutData((Object)gd);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.EmbeddedDashboard_Dashboards);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = layout.numColumns;
        label.setLayoutData((Object)gd);
        this.viewer = new TableViewer(dialogArea, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = layout.numColumns;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 0;
        this.viewer.getTable().setLayoutData((Object)gd);
        NXCSession session = ConsoleSharedData.getSession();
        this.dashboardObjects = session.findMultipleObjects(this.config.getDashboardObjects(), Dashboard.class, false);
        this.viewer.setInput((Object)this.dashboardObjects.toArray());
        Composite leftButtons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginLeft = 0;
        leftButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        leftButtons.setLayoutData((Object)gd);
        this.upButton = new Button(leftButtons, 8);
        Messages.get();
        this.upButton.setText(Messages.EmbeddedDashboard_Up);
        RowData rd = new RowData();
        rd.width = 90;
        this.upButton.setLayoutData((Object)rd);
        this.upButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                EmbeddedDashboard.this.moveUp();
            }
        });
        this.upButton.setEnabled(false);
        this.downButton = new Button(leftButtons, 8);
        Messages.get();
        this.downButton.setText(Messages.EmbeddedDashboard_Down);
        rd = new RowData();
        rd.width = 90;
        this.downButton.setLayoutData((Object)rd);
        this.downButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                EmbeddedDashboard.this.moveDown();
            }
        });
        this.downButton.setEnabled(false);
        Composite rightButtons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        rightButtons.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        rightButtons.setLayoutData((Object)gd);
        this.addButton = new Button(rightButtons, 8);
        Messages.get();
        this.addButton.setText(Messages.EmbeddedDashboard_Add);
        rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                EmbeddedDashboard.this.addDashboard();
            }
        });
        this.deleteButton = new Button(rightButtons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.EmbeddedDashboard_Delete);
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                EmbeddedDashboard.this.deleteDashboards();
            }
        });
        this.deleteButton.setEnabled(false);
        Composite refreshIntervalGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        refreshIntervalGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        refreshIntervalGroup.setLayoutData((Object)gd);
        label = new Label(refreshIntervalGroup, 0);
        Messages.get();
        label.setText(Messages.EmbeddedDashboard_DisplayTime);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.refreshIntervalScale = new Scale(refreshIntervalGroup, 256);
        this.refreshIntervalScale.setMinimum(1);
        this.refreshIntervalScale.setMaximum(600);
        this.refreshIntervalScale.setSelection(this.config.getDisplayInterval());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.refreshIntervalScale.setLayoutData((Object)gd);
        this.refreshIntervalScale.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EmbeddedDashboard.this.refreshIntervalSpinner.setSelection(EmbeddedDashboard.this.refreshIntervalScale.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.refreshIntervalSpinner = new Spinner(refreshIntervalGroup, 2048);
        this.refreshIntervalSpinner.setMinimum(1);
        this.refreshIntervalSpinner.setMaximum(600);
        this.refreshIntervalSpinner.setSelection(this.config.getDisplayInterval());
        this.refreshIntervalSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EmbeddedDashboard.this.refreshIntervalScale.setSelection(EmbeddedDashboard.this.refreshIntervalSpinner.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)EmbeddedDashboard.this.viewer.getSelection();
                EmbeddedDashboard.this.deleteButton.setEnabled(selection.size() > 0);
                EmbeddedDashboard.this.upButton.setEnabled(selection.size() == 1);
                EmbeddedDashboard.this.downButton.setEnabled(selection.size() == 1);
            }
        });
        return dialogArea;
    }

    protected void moveDown() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dashboardObjects.indexOf(element = selection.getFirstElement())) < this.dashboardObjects.size() - 1 && index >= 0) {
            Collections.swap(this.dashboardObjects, index + 1, index);
            this.viewer.setInput((Object)this.dashboardObjects.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void moveUp() {
        Object element;
        int index;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && (index = this.dashboardObjects.indexOf(element = selection.getFirstElement())) > 0) {
            Collections.swap(this.dashboardObjects, index - 1, index);
            this.viewer.setInput((Object)this.dashboardObjects.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection(element));
        }
    }

    protected void deleteDashboards() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            this.dashboardObjects.remove(o);
        }
        this.viewer.setInput((Object)this.dashboardObjects.toArray());
    }

    protected void addDashboard() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell(), ObjectSelectionDialog.createDashboardSelectionFilter());
        if (dlg.open() == 0) {
            this.dashboardObjects.addAll(Arrays.asList(dlg.getSelectedObjects(Dashboard.class)));
            this.viewer.setInput((Object)this.dashboardObjects.toArray());
        }
    }

    public boolean performOk() {
        this.title.updateConfiguration(this.config);
        long[] idList = new long[this.dashboardObjects.size()];
        int i = 0;
        while (i < this.dashboardObjects.size()) {
            idList[i] = this.dashboardObjects.get(i).getObjectId();
            ++i;
        }
        this.config.setDashboardObjects(idList);
        this.config.setContextObjectId(this.contextObjectSelector.getObjectId());
        this.config.setDisplayInterval(this.refreshIntervalSpinner.getSelection());
        return true;
    }
}

