/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netxms.ui.eclipse.dashboard.dialogs.helpers.ObjectIdMatchingData;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(name="element", strict=false)
public class ObjectDetailsConfig
extends DashboardElementConfig {
    @Element(required=false)
    private String query = "";
    @Element(required=false)
    private long rootObjectId = 0L;
    @ElementList(required=false)
    private List<ObjectProperty> properties;
    @Element(required=false)
    private int refreshRate = 60;
    @ElementList(required=false)
    private List<String> orderingProperties = null;
    @Element(required=false)
    private int recordLimit = 0;

    @Override
    public Set<Long> getObjects() {
        Set<Long> objects = super.getObjects();
        objects.add(this.rootObjectId);
        return objects;
    }

    @Override
    public void remapObjects(Map<Long, ObjectIdMatchingData> remapData) {
        super.remapObjects(remapData);
        ObjectIdMatchingData md = remapData.get(this.rootObjectId);
        if (md != null) {
            this.rootObjectId = md.dstId;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public long getRootObjectId() {
        return this.rootObjectId;
    }

    public void setRootObjectId(long rootObjectId) {
        this.rootObjectId = rootObjectId;
    }

    public List<ObjectProperty> getProperties() {
        return this.properties == null ? new ArrayList() : this.properties;
    }

    public void setProperties(List<ObjectProperty> properties) {
        this.properties = properties;
    }

    public List<String> getOrderingProperties() {
        return this.orderingProperties == null ? new ArrayList() : this.orderingProperties;
    }

    public String getOrderingPropertiesAsText() {
        if (this.orderingProperties == null || this.orderingProperties.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.orderingProperties.get(0));
        int i = 1;
        while (i < this.orderingProperties.size()) {
            sb.append(',');
            sb.append(this.orderingProperties.get(i));
            ++i;
        }
        return sb.toString();
    }

    public void setOrderingProperties(List<String> orderingProperties) {
        this.orderingProperties = orderingProperties;
    }

    public void setOrderingProperties(String orderingProperties) {
        if (orderingProperties == null || orderingProperties.isEmpty()) {
            this.orderingProperties = null;
        } else {
            String[] parts = orderingProperties.split(",");
            this.orderingProperties = new ArrayList<String>(parts.length);
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                if (!(p = p.trim()).isEmpty()) {
                    this.orderingProperties.add(p);
                }
                ++n2;
            }
        }
    }

    public int getRefreshRate() {
        return this.refreshRate;
    }

    public void setRefreshRate(int refreshRate) {
        this.refreshRate = refreshRate;
    }

    public int getRecordLimit() {
        return this.recordLimit;
    }

    public void setRecordLimit(int recordLimit) {
        this.recordLimit = recordLimit;
    }

    @Root(name="property", strict=false)
    public static class ObjectProperty {
        public static final int STRING = 0;
        public static final int INTEGER = 1;
        public static final int FLOAT = 2;
        @Element
        public String name;
        @Element(required=false)
        public String displayName;
        @Attribute(required=false)
        public int type;

        public ObjectProperty() {
            this.name = "";
            this.displayName = "";
            this.type = 0;
        }

        public ObjectProperty(ObjectProperty src) {
            this.name = src.name;
            this.displayName = src.displayName;
            this.type = src.type;
        }
    }
}

