/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs.helpers;

import org.eclipse.swt.events.VerifyListener;
import org.netxms.client.datacollection.BulkDciUpdateElement;

public class BulkDciUpdateElementUI
extends BulkDciUpdateElement {
    private String name;
    private String[] possibleValues;
    private VerifyListener verifyListener;
    private EditModeSelector callback;
    private boolean editableDropdown = false;

    public BulkDciUpdateElementUI(String name, long fieldId, String[] possibleValues) {
        super(fieldId);
        this.name = name;
        this.possibleValues = possibleValues;
        this.verifyListener = null;
    }

    public BulkDciUpdateElementUI(String name, long fieldId, String[] possibleValues, EditModeSelector callback) {
        super(fieldId);
        this.name = name;
        this.possibleValues = possibleValues;
        this.verifyListener = null;
        this.callback = callback;
    }

    public BulkDciUpdateElementUI(String name, long fieldId, String[] possibleValues, VerifyListener verifyListener) {
        super(fieldId);
        this.name = name;
        this.possibleValues = possibleValues;
        this.verifyListener = verifyListener;
        this.callback = null;
    }

    public String getTextValue() {
        if (this.value != null && this.value instanceof String) {
            return (String)this.value;
        }
        return this.editableDropdown ? this.possibleValues[0] : "";
    }

    public Integer getSelectionValue() {
        if (this.value != null && this.value instanceof Integer) {
            return (Integer)this.value;
        }
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public String[] getPossibleValues() {
        return this.possibleValues;
    }

    public boolean isText() {
        return this.possibleValues == null;
    }

    public VerifyListener getVerifyListener() {
        return this.verifyListener;
    }

    public boolean isEditable() {
        if (this.callback != null) {
            return this.callback.isEditable();
        }
        return true;
    }

    public void setEditableDropdown(boolean editableDropdown) {
        this.editableDropdown = editableDropdown;
    }

    public boolean isEditableDropdown() {
        return this.editableDropdown;
    }

    public void setValue(Object value) {
        this.value = this.isText() ? (((String)value).isEmpty() ? null : value) : (this.editableDropdown ? (this.possibleValues[0].equals(value) ? null : value) : Integer.valueOf((Integer)value - 1));
    }

    public Object getValue() {
        if (this.isText() || this.editableDropdown) {
            return this.getTextValue();
        }
        return this.getSelectionValue() + 1;
    }

    public String getDisplayText() {
        if (this.editableDropdown) {
            return this.getTextValue();
        }
        if (this.isText()) {
            return this.getTextValue().isEmpty() ? "No change" : this.getTextValue();
        }
        return this.possibleValues[this.getSelectionValue() + 1];
    }

    public static interface EditModeSelector {
        public boolean isEditable();
    }
}

