/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import java.io.Serializable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.nxmc.base.widgets.ExtendedColorSelector;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.netxms.nxmc.modules.datacollection.widgets.TemplateDciSelector;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class DataSourceEditDlg
extends Dialog {
    private final I18n i18n = LocalizationHelper.getI18n(DataSourceEditDlg.class);
    private ChartDciConfig dci;
    private DciSelector dciSelector;
    private LabeledText name;
    private LabeledText displayFormat;
    private TemplateDciSelector dciName;
    private TemplateDciSelector dciDescription;
    private TemplateDciSelector dciTag;
    private ExtendedColorSelector colorSelector;
    private Combo displayType;
    private Button checkShowThresholds;
    private Button checkInvertValues;
    private Button checkRawValues;
    private Button checkMultipeMatch;
    private Button checkRegexpMatch;
    private LabeledText instance;
    private LabeledText dataColumn;
    private boolean isTemplate;
    private boolean isNew;

    public DataSourceEditDlg(Shell parentShell, ChartDciConfig dci, boolean isNew, boolean isTemplate) {
        super(parentShell);
        this.dci = dci;
        this.isNew = isNew;
        this.isTemplate = isTemplate;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Edit Data Source"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        if (this.isTemplate) {
            this.dciName = new TemplateDciSelector(dialogArea, 0);
            this.dciName.setLabel(this.i18n.tr("Metric"));
            this.dciName.setText(this.dci.dciName);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.dciName.setLayoutData((Object)gd);
            this.addTemplateSelectorListener(this.dciName);
            this.dciDescription = new TemplateDciSelector(dialogArea, 0);
            this.dciDescription.setLabel(this.i18n.tr("DCI display name"));
            this.dciDescription.setText(this.dci.dciDescription);
            this.dciDescription.setField(TemplateDciSelector.Field.DESCRIPTION);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.dciDescription.setLayoutData((Object)gd);
            this.addTemplateSelectorListener(this.dciDescription);
            this.dciTag = new TemplateDciSelector(dialogArea, 0);
            this.dciTag.setLabel(this.i18n.tr("DCI tag"));
            this.dciTag.setText(this.dci.dciTag);
            this.dciTag.setField(TemplateDciSelector.Field.TAG);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.dciTag.setLayoutData((Object)gd);
            this.addTemplateSelectorListener(this.dciTag);
        } else {
            this.dciSelector = new DciSelector(dialogArea, 0);
            this.dciSelector.setLabel(this.i18n.tr("Data collection item"));
            this.dciSelector.setDciId(this.dci.nodeId, this.dci.dciId);
            this.dciSelector.setDcObjectType(this.dci.type);
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 400;
            gd.horizontalSpan = 2;
            this.dciSelector.setLayoutData((Object)gd);
        }
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(this.i18n.tr("Label (Leave empty to use DCI display name)"));
        this.name.setText(this.dci.name);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.displayFormat = new LabeledText(dialogArea, 0);
        this.displayFormat.setLabel(this.i18n.tr("Display format"));
        this.displayFormat.setText(this.dci.displayFormat);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.displayFormat.setLayoutData((Object)gd);
        if (this.dci.type == 2) {
            Group tableGroup = new Group(dialogArea, 0);
            tableGroup.setText(this.i18n.tr("Table Cell"));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            tableGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            tableGroup.setLayout((Layout)layout);
            this.dataColumn = new LabeledText((Composite)tableGroup, 0);
            this.dataColumn.setLabel(this.i18n.tr("Data column"));
            this.dataColumn.setText(this.dci.column);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.dataColumn.setLayoutData((Object)gd);
            this.instance = new LabeledText((Composite)tableGroup, 0);
            this.instance.setLabel(this.i18n.tr("Instance"));
            this.instance.setText(this.dci.instance);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.instance.setLayoutData((Object)gd);
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.displayType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)this.i18n.tr("Display type"), (Object)gd);
        this.displayType.add("Default");
        this.displayType.add("Line");
        this.displayType.add("Area");
        this.displayType.select(this.dci.getLineChartType() + 1);
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(this.i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        gd.verticalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        this.checkShowThresholds = new Button((Composite)optionsGroup, 32);
        this.checkShowThresholds.setText(this.i18n.tr("Show &thresholds"));
        this.checkShowThresholds.setSelection(this.dci.showThresholds);
        this.checkInvertValues = new Button((Composite)optionsGroup, 32);
        this.checkInvertValues.setText(this.i18n.tr("&Invert values"));
        this.checkInvertValues.setSelection(this.dci.invertValues);
        this.checkRawValues = new Button((Composite)optionsGroup, 32);
        this.checkRawValues.setText(this.i18n.tr("&Raw values"));
        this.checkRawValues.setSelection(this.dci.useRawValues);
        if (this.isTemplate) {
            this.checkMultipeMatch = new Button((Composite)optionsGroup, 32);
            this.checkMultipeMatch.setText(this.i18n.tr("&Multiple match"));
            this.checkMultipeMatch.setSelection(this.dci.multiMatch);
            this.checkRegexpMatch = new Button((Composite)optionsGroup, 32);
            this.checkRegexpMatch.setText(this.i18n.tr("Use regular &expressions for DCI matching"));
            this.checkRegexpMatch.setSelection(this.isNew ? false : this.dci.regexMatch);
        }
        this.colorSelector = new ExtendedColorSelector(dialogArea);
        this.colorSelector.setLabels(this.i18n.tr("Color"), this.i18n.tr("&Automatic color"), this.i18n.tr("&Custom color:"));
        this.colorSelector.setColorValue(this.dci.color.equalsIgnoreCase("UNSET") ? null : ColorConverter.rgbFromInt((int)this.dci.getColorAsInt()));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        this.colorSelector.setLayoutData((Object)gd);
        return dialogArea;
    }

    private void addTemplateSelectorListener(TemplateDciSelector selector) {
        selector.addModifyListener((ModifyListener & Serializable)e -> {
            if (selector.isNoValueObject()) {
                this.checkMultipeMatch.setSelection(true);
                this.checkRegexpMatch.setSelection(true);
                if (this.name.getText().isEmpty()) {
                    this.name.setText("\\1");
                }
            }
        });
    }

    protected void okPressed() {
        if (this.isTemplate) {
            this.dci.dciName = this.dciName.getText();
            this.dci.dciDescription = this.dciDescription.getText();
            this.dci.dciTag = this.dciTag.getText();
            this.dci.multiMatch = this.checkMultipeMatch.getSelection();
            this.dci.regexMatch = this.checkRegexpMatch.getSelection();
        } else {
            this.dci.nodeId = this.dciSelector.getNodeId();
            this.dci.dciId = this.dciSelector.getDciId();
        }
        this.dci.name = this.name.getText();
        this.dci.displayFormat = this.displayFormat.getText();
        RGB color = this.colorSelector.getColorValue();
        this.dci.color = color == null ? "UNSET" : "0x" + Integer.toHexString(ColorConverter.rgbToInt((RGB)color));
        this.dci.lineChartType = this.displayType.getSelectionIndex() - 1;
        this.dci.showThresholds = this.checkShowThresholds.getSelection();
        this.dci.invertValues = this.checkInvertValues.getSelection();
        this.dci.useRawValues = this.checkRawValues.getSelection();
        if (this.dci.type == 2) {
            this.dci.column = this.dataColumn.getText().trim();
            this.dci.instance = this.instance.getText();
        }
        super.okPressed();
    }
}

