/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.tools;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class RefreshTimer {
    private static ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(4, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
    private Display display;
    private Control control;
    private Runnable callback;
    private long interval;
    private long lastRun = 0L;
    private long minimalDelay = 0L;
    private boolean scheduled = false;
    private boolean refreshDisabled = false;
    private boolean updateMissed = false;

    public RefreshTimer(int interval, Control control, Runnable callback) {
        this.interval = interval;
        this.control = control;
        this.display = control.getDisplay();
        this.callback = callback;
    }

    public RefreshTimer(int interval, Display display, Runnable callback) {
        this.interval = interval;
        this.control = null;
        this.display = display;
        this.callback = callback;
    }

    public synchronized void execute() {
        if (this.refreshDisabled) {
            this.updateMissed = true;
            return;
        }
        long curr = System.currentTimeMillis();
        if ((this.interval <= 0L || curr - this.lastRun >= this.interval) && this.minimalDelay == 0L) {
            this.lastRun = curr;
            this.display.asyncExec(() -> {
                if (this.control == null || !this.control.isDisposed()) {
                    this.callback.run();
                }
            });
        } else if (!this.scheduled) {
            int delay = (int)Math.max(this.interval - (curr - this.lastRun), this.minimalDelay);
            this.scheduled = true;
            executor.schedule((Runnable)new /* Unavailable Anonymous Inner Class!! */, (long)delay, TimeUnit.MILLISECONDS);
        }
    }

    private synchronized void onTimer() {
        this.lastRun = System.currentTimeMillis();
        this.scheduled = false;
    }

    public synchronized void disableRefresh() {
        this.refreshDisabled = true;
    }

    public synchronized void enableRefresh() {
        this.refreshDisabled = false;
        if (this.updateMissed) {
            this.execute();
        }
    }

    public void setMinimalDelay(long minimalDelay) {
        this.minimalDelay = minimalDelay;
    }
}

