/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.preferencepages;

import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.preferencepages.LanguagePage;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.base.widgets.LabeledCombo;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.resources.ThemeEngine;
import org.xnap.commons.i18n.I18n;

public class LanguagePage
extends PropertyPage {
    private final I18n i18n = LocalizationHelper.getI18n(LanguagePage.class);
    private static final Language[] languages = new Language[]{new Language("de", "Deutsch - German"), new Language("en", "English"), new Language("es", "Espa\u00f1ol - Spanish"), new Language("fr", "Fran\u00e7ais - French"), new Language("pt_BR", "Portugu\u00eas - Portuguese (Brazil)"), new Language("ru", "\u0420\u0443\u0441\u0441\u043a\u0438\u0439 - Russian")};
    private PreferenceStore settings = PreferenceStore.getInstance();
    private LabeledCombo languageSelector;

    public LanguagePage() {
        super(LocalizationHelper.getI18n(LanguagePage.class).tr("Language"));
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        dialogArea.setLayout((Layout)layout);
        String currentLanguage = this.settings.getAsString("nxmc.language", "en");
        this.languageSelector = new LabeledCombo(dialogArea, 0);
        this.languageSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.languageSelector.setLabel(this.i18n.tr("Selected language"));
        for (int i = 0; i < languages.length; ++i) {
            this.languageSelector.add(LanguagePage.languages[i].name);
            if (!LanguagePage.languages[i].code.equals(currentLanguage)) continue;
            this.languageSelector.select(i);
        }
        Composite messageArea = this.createMessageArea(dialogArea);
        messageArea.setVisible(false);
        this.languageSelector.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private Composite createMessageArea(Composite parent) {
        Composite messageArea = new Composite(parent, 2048);
        messageArea.setBackground(ThemeEngine.getBackgroundColor((String)"MessageBar"));
        GridLayout layout = new GridLayout(2, false);
        messageArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        gd.grabExcessHorizontalSpace = true;
        messageArea.setLayoutData((Object)gd);
        Label imageLabel = new Label(messageArea, 0);
        imageLabel.setBackground(messageArea.getBackground());
        imageLabel.setImage(ResourceManager.getImage((String)"icons/warning.png"));
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 4;
        imageLabel.setLayoutData((Object)gd);
        imageLabel.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        Label messageLabel = new Label(messageArea, 64);
        messageLabel.setBackground(messageArea.getBackground());
        messageLabel.setForeground(ThemeEngine.getForegroundColor((String)"MessageBar"));
        messageLabel.setText(this.i18n.tr("You have to relogin for language change to take effect"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 0x1000000;
        messageLabel.setLayoutData((Object)gd);
        return messageArea;
    }

    protected boolean applyChanges(boolean isApply) {
        int index = this.languageSelector.getSelectionIndex();
        if (index == -1) {
            return false;
        }
        this.settings.set("nxmc.language", LanguagePage.languages[index].code);
        return true;
    }
}

