/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.propertypages;

import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.nxmc.base.propertypages.PropertyPage;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.networkmaps.propertypages.DCIContainerGeneral;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class DCIContainerGeneral
extends PropertyPage {
    private I18n i18n = LocalizationHelper.getI18n(DCIContainerGeneral.class);
    private NetworkMapDCIContainer container;
    private ColorSelector backgroundColorSelector;
    private ColorSelector textColorSelector;
    private ColorSelector borderColorSelector;
    private Button borderCheckbox;

    public DCIContainerGeneral(NetworkMapDCIContainer container) {
        super(LocalizationHelper.getI18n(DCIContainerGeneral.class).tr("General"));
        this.container = container;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.backgroundColorSelector = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)this.i18n.tr("Background color"), (Object)"WidgetHelper::default_layout_data");
        this.backgroundColorSelector.setColorValue(ColorConverter.rgbFromInt((int)this.container.getBackgroundColor()));
        this.textColorSelector = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)this.i18n.tr("Text color"), (Object)"WidgetHelper::default_layout_data");
        this.textColorSelector.setColorValue(ColorConverter.rgbFromInt((int)this.container.getTextColor()));
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        this.borderCheckbox = new Button(dialogArea, 32);
        this.borderCheckbox.setText(this.i18n.tr("Show &border"));
        this.borderCheckbox.setSelection(this.container.isBorderRequired());
        this.borderCheckbox.addSelectionListener((SelectionListener)listener);
        this.borderColorSelector = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)this.i18n.tr("Border color"), (Object)"WidgetHelper::default_layout_data");
        this.borderColorSelector.setColorValue(ColorConverter.rgbFromInt((int)this.container.getBorderColor()));
        this.borderColorSelector.setEnabled(this.borderCheckbox.getSelection());
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.container.setBackgroundColor(ColorConverter.rgbToInt((RGB)this.backgroundColorSelector.getColorValue()));
        this.container.setTextColor(ColorConverter.rgbToInt((RGB)this.textColorSelector.getColorValue()));
        this.container.setBorderRequired(this.borderCheckbox.getSelection());
        this.container.setBorderColor(ColorConverter.rgbToInt((RGB)this.borderColorSelector.getColorValue()));
        return true;
    }
}

