/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.AbstractSelector;
import org.netxms.nxmc.base.widgets.helpers.SelectorConfigurator;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ZoneSelectionDialog;
import org.xnap.commons.i18n.I18n;

public class ZoneSelector
extends AbstractSelector {
    private I18n i18n = LocalizationHelper.getI18n(ZoneSelector.class);
    private int zoneUIN = -1;
    private String emptySelectionName = this.i18n.tr("<none>");

    public ZoneSelector(Composite parent, int style, SelectorConfigurator configurator) {
        super(parent, style, configurator);
        this.setText(this.emptySelectionName);
    }

    public ZoneSelector(Composite parent, int style, boolean showClearButton) {
        this(parent, style, new SelectorConfigurator().setShowClearButton(showClearButton));
    }

    protected void selectionButtonHandler() {
        ZoneSelectionDialog dlg = new ZoneSelectionDialog(this.getShell());
        if (dlg.open() == 0) {
            this.zoneUIN = dlg.getZoneUIN();
            this.setText(dlg.getZoneName());
            this.fireModifyListeners();
        }
    }

    protected void clearButtonHandler() {
        this.zoneUIN = -1;
        this.setText(this.emptySelectionName);
        this.fireModifyListeners();
    }

    public int getZoneUIN() {
        return this.zoneUIN;
    }

    public String getZoneName() {
        return this.getText();
    }

    public void setZoneUIN(int zoneUIN) {
        this.zoneUIN = zoneUIN;
        if (zoneUIN == -1) {
            this.setText(this.emptySelectionName);
        } else {
            Zone zone = Registry.getSession().findZone(zoneUIN);
            this.setText((String)(zone != null ? zone.getObjectName() : "<" + Long.toString(zoneUIN) + ">"));
        }
    }

    public void setEmptySelectionText(String text) {
        this.emptySelectionName = text;
        this.setText(this.emptySelectionName);
    }
}

