/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.reporting.ReportParameter;
import org.netxms.nxmc.modules.reporting.widgets.ReportFieldEditor;

public class TimestampFieldEditor
extends ReportFieldEditor {
    private DateTime datePicker;
    private DateTime timePicker;

    public TimestampFieldEditor(ReportParameter parameter, Composite parent) {
        super(parameter, parent);
    }

    protected void setupLocalization() {
    }

    protected Control createContent(Composite parent) {
        Date date;
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        area.setLayout((Layout)layout);
        try {
            date = new Date(Long.parseLong(this.parameter.getDefaultValue()) * 1000L);
        }
        catch (NumberFormatException e) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        this.datePicker = new DateTime(area, 2084);
        this.datePicker.setDate(c.get(1), c.get(2), c.get(5));
        this.timePicker = new DateTime(area, 2176);
        this.timePicker.setTime(c.get(11), c.get(12), c.get(13));
        return area;
    }

    public String getValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(this.datePicker.getYear(), this.datePicker.getMonth(), this.datePicker.getDay(), this.timePicker.getHours(), this.timePicker.getMinutes(), this.timePicker.getSeconds());
        return Long.toString(calendar.getTimeInMillis() / 1000L);
    }
}

