/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.reporting.widgets.helpers;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.ScheduledTask;
import org.netxms.client.reporting.ReportingJob;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.DateFormatFactory;
import org.netxms.nxmc.tools.ViewerElementUpdater;

public class ScheduleLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private TableViewer viewer;

    public ScheduleLabelProvider(TableViewer viewer) {
        this.viewer = viewer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ScheduledTask task = ((ReportingJob)element).getTask();
        switch (columnIndex) {
            case 0: {
                return task.getSchedule().isEmpty() ? DateFormatFactory.getDateTimeFormat().format(task.getExecutionTime()) : task.getSchedule();
            }
            case 1: {
                AbstractUserObject user = Registry.getSession().findUserDBObjectById(task.getOwner(), (Runnable)new ViewerElementUpdater((ColumnViewer)this.viewer, element));
                return user != null ? user.getName() : "[" + task.getOwner() + "]";
            }
            case 2: {
                return task.getLastExecutionTime().getTime() == 0L ? "" : DateFormatFactory.getDateTimeFormat().format(task.getLastExecutionTime());
            }
            case 3: {
                return task.getStatus();
            }
        }
        return "<INTERNAL ERROR>";
    }
}

