/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.StyledText;
import org.netxms.nxmc.base.widgets.helpers.LineStyler;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.widgets.LocalFileSelector;
import org.netxms.nxmc.modules.serverconfig.views.ImportConfiguration;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class ImportConfiguration
extends ConfigurationView {
    private final I18n i18n = LocalizationHelper.getI18n(ImportConfiguration.class);
    private LocalFileSelector fileSelector;
    private Button buttonImport;
    private Group options;
    private List<Button> buttonFlags = new ArrayList();
    private Button buttonSelectAll;
    private Button buttonDeselectAll;
    private StyledText text;
    private Action actionImport;

    public ImportConfiguration() {
        super(LocalizationHelper.getI18n(ImportConfiguration.class).tr("Import Configuration"), SharedIcons.IMPORT, "config.import", false);
    }

    protected void createContent(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        this.fileSelector = new LocalFileSelector(parent, 0, false, 4100);
        this.fileSelector.setLabel(this.i18n.tr("File name"));
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.fileSelector.setLayoutData((Object)gd);
        this.fileSelector.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.buttonImport = new Button(parent, 8);
        this.buttonImport.setText(this.i18n.tr("Import"));
        this.buttonImport.setToolTipText(this.i18n.tr("Start import from selected file (F9)"));
        this.buttonImport.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.widthHint = 90;
        this.buttonImport.setLayoutData((Object)gd);
        this.buttonImport.setEnabled(false);
        this.options = new Group(parent, 0);
        this.options.setText(this.i18n.tr("Options"));
        GridLayout optionsLayout = new GridLayout();
        optionsLayout.numColumns = 3;
        this.options.setLayout((Layout)optionsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.options.setLayoutData((Object)gd);
        this.addOptionCheckBox(this.i18n.tr("Replace &actions"), 2);
        this.addOptionCheckBox(this.i18n.tr("Replace asset &management attributes"), 2048);
        this.addOptionCheckBox(this.i18n.tr("Replace &DCI summary tables"), 32);
        this.addOptionCheckBox(this.i18n.tr("Replace EPP &rules"), 128);
        this.addOptionCheckBox(this.i18n.tr("Replace &events"), 1);
        this.addOptionCheckBox(this.i18n.tr("Replace library &scripts"), 16);
        this.addOptionCheckBox(this.i18n.tr("Replace &object tools"), 64);
        this.addOptionCheckBox(this.i18n.tr("Replace S&NMP traps"), 8);
        this.addOptionCheckBox(this.i18n.tr("Replace &templates"), 4);
        this.addOptionCheckBox(this.i18n.tr("Replace template names and &locations"), 256);
        this.addOptionCheckBox(this.i18n.tr("Replace &web service definitions"), 1024);
        this.addOptionCheckBox(this.i18n.tr("Remove empty template &groups after import"), 512);
        Composite buttons = new Composite((Composite)this.options, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 3;
        buttons.setLayoutData((Object)gd);
        this.buttonSelectAll = new Button(buttons, 8);
        this.buttonSelectAll.setText(this.i18n.tr("&Select all"));
        this.buttonSelectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 90;
        this.buttonSelectAll.setLayoutData((Object)gd);
        this.buttonDeselectAll = new Button(buttons, 8);
        this.buttonDeselectAll.setText(this.i18n.tr("&Clear all"));
        this.buttonDeselectAll.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 90;
        this.buttonDeselectAll.setLayoutData((Object)gd);
        new Label(parent, 0).setText(this.i18n.tr("Import log"));
        this.text = new StyledText(parent, 2816);
        this.text.setEditable(false);
        this.text.setFont(JFaceResources.getTextFont());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalSpan = 2;
        this.text.setLayoutData((Object)gd);
        5 lineStyler = new /* Unavailable Anonymous Inner Class!! */;
        this.text.setLineStyler((LineStyler)lineStyler);
        this.createActions();
    }

    private void createActions() {
        this.actionImport = new /* Unavailable Anonymous Inner Class!! */;
        this.actionImport.setEnabled(false);
        this.addKeyBinding("F9", (IAction)this.actionImport);
    }

    private void addOptionCheckBox(String text, int flag) {
        Button button = new Button((Composite)this.options, 32);
        button.setText(text);
        button.setData("BitFlag", (Object)flag);
        this.buttonFlags.add(button);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionImport);
        super.fillLocalToolBar(manager);
    }

    protected void fillLocalMenu(IMenuManager manager) {
        manager.add((IAction)this.actionImport);
        super.fillLocalMenu(manager);
    }

    private void doImport() {
        this.text.setText("");
        int flagBuilder = 0;
        for (Button button : this.buttonFlags) {
            if (!button.getSelection()) continue;
            flagBuilder |= ((Integer)button.getData("BitFlag")).intValue();
        }
        int flags = flagBuilder;
        NXCSession session = Registry.getSession();
        7 job = new /* Unavailable Anonymous Inner Class!! */;
        job.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

