/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.property.value;

import java.util.Objects;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IPropertyObservable;
import org.eclipse.core.databinding.property.SimplePropertyEvent;
import org.eclipse.core.databinding.property.value.SimpleValueProperty;

public class SimplePropertyObservableValue<S, T>
extends AbstractObservableValue<T>
implements IPropertyObservable<SimpleValueProperty<S, T>> {
    private S source;
    private SimpleValueProperty<S, T> property;
    private boolean updating = false;
    private T cachedValue;
    private boolean stale;
    private INativePropertyListener<S> listener;

    public SimplePropertyObservableValue(Realm realm, S source, SimpleValueProperty<S, T> property) {
        super(realm);
        this.source = source;
        this.property = property;
    }

    protected void firstListenerAdded() {
        if (!this.isDisposed() && this.listener == null) {
            this.listener = this.property.adaptListener(event -> {
                if (!this.isDisposed() && !this.updating) {
                    this.getRealm().exec(() -> {
                        if (simplePropertyEvent.type == SimplePropertyEvent.CHANGE) {
                            this.notifyIfChanged((ValueDiff)simplePropertyEvent.diff);
                        } else if (simplePropertyEvent.type == SimplePropertyEvent.STALE && !this.stale) {
                            this.stale = true;
                            this.fireStale();
                        }
                    });
                }
            });
        }
        this.getRealm().exec(() -> {
            this.cachedValue = this.property.getValue(this.source);
            this.stale = false;
            if (this.listener != null) {
                this.listener.addTo(this.source);
            }
        });
    }

    protected void lastListenerRemoved() {
        if (this.listener != null) {
            this.listener.removeFrom(this.source);
        }
        this.cachedValue = null;
        this.stale = false;
    }

    protected T doGetValue() {
        this.notifyIfChanged(null);
        return this.property.getValue(this.source);
    }

    protected void doSetValue(T value) {
        this.updating = true;
        try {
            this.property.setValue(this.source, value);
        }
        finally {
            this.updating = false;
        }
        this.notifyIfChanged(null);
    }

    private void notifyIfChanged(ValueDiff<? extends T> diff) {
        if (this.hasListeners()) {
            T oldValue = this.cachedValue;
            this.cachedValue = this.property.getValue(this.source);
            Object newValue = this.cachedValue;
            if (diff == null) {
                diff = Diffs.createValueDiff(oldValue, newValue);
            }
            if (!Objects.equals(oldValue, newValue) || this.stale) {
                this.stale = false;
                this.fireValueChange(Diffs.unmodifiableDiff((ValueDiff)diff));
            }
        }
    }

    public Object getValueType() {
        return this.property.getValueType();
    }

    public Object getObserved() {
        return this.source;
    }

    @Override
    public SimpleValueProperty<S, T> getProperty() {
        return this.property;
    }

    public boolean isStale() {
        ObservableTracker.getterCalled((IObservable)this);
        return this.stale;
    }

    public synchronized void dispose() {
        if (!this.isDisposed()) {
            if (this.listener != null) {
                this.listener.removeFrom(this.source);
            }
            this.source = null;
            this.property = null;
            this.listener = null;
            this.stale = false;
        }
        super.dispose();
    }
}

