/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.events;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.client.constants.Severity;

public class EventTemplate {
    public static final int FLAG_WRITE_TO_LOG = 1;
    public static final int FLAG_DO_NOT_MONITOR = 2;
    private int code;
    private UUID guid;
    private String name;
    private String message;
    private String description;
    private Severity severity;
    private int flags;
    private String tagList;
    private Set<String> tags;

    public EventTemplate(int code) {
        this.code = code;
        this.guid = NXCommon.EMPTY_GUID;
        this.name = "";
        this.message = "";
        this.description = "";
        this.severity = Severity.NORMAL;
        this.flags = 1;
        this.tagList = "";
        this.tags = new HashSet<String>();
    }

    public EventTemplate(NXCPMessage msg, long baseId) {
        this.code = msg.getFieldAsInt32(baseId + 1L);
        this.description = msg.getFieldAsString(baseId + 2L);
        this.name = msg.getFieldAsString(baseId + 3L);
        this.severity = Severity.getByValue(msg.getFieldAsInt32(baseId + 4L));
        this.flags = msg.getFieldAsInt32(baseId + 5L);
        this.message = msg.getFieldAsString(baseId + 6L);
        this.tags = new HashSet<String>();
        this.tagList = msg.getFieldAsString(baseId + 7L);
        if (this.tagList != null && !this.tagList.isEmpty()) {
            String[] stringArray = this.tagList.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.tags.add(s);
                ++n2;
            }
        }
        this.guid = msg.getFieldAsUUID(baseId + 8L);
        if (this.guid == null) {
            this.guid = NXCommon.EMPTY_GUID;
        }
    }

    public EventTemplate(EventTemplate src) {
        this.code = src.code;
        this.guid = src.guid;
        this.name = src.name;
        this.description = src.description;
        this.severity = src.severity;
        this.flags = src.flags;
        this.message = src.message;
        this.tagList = src.tagList;
        this.tags = new HashSet<String>(src.tags);
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setFieldInt32(24L, this.code);
        msg.setField(20L, this.name);
        msg.setField(26L, this.message);
        msg.setField(27L, this.description);
        msg.setFieldInt32(25L, this.severity.getValue());
        msg.setFieldInt32(13L, this.flags);
        if (!this.tags.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : this.tags) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
            msg.setField(645L, sb.toString());
        }
    }

    public void setAll(EventTemplate src) {
        this.code = src.code;
        this.guid = src.guid;
        this.name = src.name;
        this.message = src.message;
        this.description = src.description;
        this.severity = src.severity;
        this.flags = src.flags;
        this.tagList = src.tagList;
        this.tags = new HashSet<String>(src.tags);
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
        if (!tags.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String s : tags) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
            this.tagList = sb.toString();
        } else {
            this.tagList = "";
        }
    }

    public String getTagList() {
        return this.tagList != null ? this.tagList : "";
    }

    public String toString() {
        return "EventTemplate [code=" + this.code + ", name=" + this.name + ", message=" + this.message + ", description=" + this.description + ", severity=" + (Object)((Object)this.severity) + ", flags=" + this.flags + ", tagList=" + this.tagList + ", tags=" + this.tags + "]";
    }
}

