/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views.helpers;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Messages;

public class SnmpTrapComparator
extends ViewerComparator {
    private NXCSession session = ConsoleSharedData.getSession();

    public int compare(Viewer viewer, Object e1, Object e2) {
        TableColumn sortColumn = ((TableViewer)viewer).getTable().getSortColumn();
        if (sortColumn == null) {
            return 0;
        }
        SnmpTrap trap1 = (SnmpTrap)e1;
        SnmpTrap trap2 = (SnmpTrap)e2;
        int rc = switch ((Integer)sortColumn.getData("ID")) {
            case 0 -> Long.signum(trap1.getId() - trap2.getId());
            case 1 -> trap1.getObjectId().compareTo(trap2.getObjectId());
            case 2 -> {
                String v1;
                String name1;
                EventTemplate evt1 = this.session.findEventTemplateByCode(trap1.getEventCode());
                EventTemplate evt2 = this.session.findEventTemplateByCode(trap2.getEventCode());
                if (evt1 != null) {
                    v0 = evt1.getName();
                } else {
                    Messages.get();
                    v0 = name1 = Messages.SnmpTrapComparator_Unknown;
                }
                if (evt2 != null) {
                    v1 = evt2.getName();
                } else {
                    Messages.get();
                    v1 = Messages.SnmpTrapComparator_Unknown;
                }
                String name2 = v1;
                yield name1.compareToIgnoreCase(name2);
            }
            case 3 -> trap1.getDescription().compareToIgnoreCase(trap2.getDescription());
            default -> 0;
        };
        int dir = ((TableViewer)viewer).getTable().getSortDirection();
        return dir == 128 ? rc : -rc;
    }
}

