/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.console.resources.ThemeEngine;
import org.netxms.ui.eclipse.dashboard.Activator;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.dialogs.EditElementXmlDlg;
import org.netxms.ui.eclipse.dashboard.views.DashboardControlOwner;
import org.netxms.ui.eclipse.dashboard.widgets.AlarmViewerElement;
import org.netxms.ui.eclipse.dashboard.widgets.AvailabilityChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.BarChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.CustomWidgetElement;
import org.netxms.ui.eclipse.dashboard.widgets.DciSummaryTableElement;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.EmbeddedDashboardElement;
import org.netxms.ui.eclipse.dashboard.widgets.EventMonitorElement;
import org.netxms.ui.eclipse.dashboard.widgets.FileMonitorElement;
import org.netxms.ui.eclipse.dashboard.widgets.GaugeElement;
import org.netxms.ui.eclipse.dashboard.widgets.GeoMapElement;
import org.netxms.ui.eclipse.dashboard.widgets.LabelElement;
import org.netxms.ui.eclipse.dashboard.widgets.LineChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.NetworkMapElement;
import org.netxms.ui.eclipse.dashboard.widgets.ObjectQuery;
import org.netxms.ui.eclipse.dashboard.widgets.ObjectStatusChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.ObjectTools;
import org.netxms.ui.eclipse.dashboard.widgets.PieChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.PortViewElement;
import org.netxms.ui.eclipse.dashboard.widgets.RackDiagramElement;
import org.netxms.ui.eclipse.dashboard.widgets.ScriptedBarChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.ScriptedPieChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.SeparatorElement;
import org.netxms.ui.eclipse.dashboard.widgets.ServiceComponentsElement;
import org.netxms.ui.eclipse.dashboard.widgets.SnmpTrapMonitorElement;
import org.netxms.ui.eclipse.dashboard.widgets.StatusIndicatorElement;
import org.netxms.ui.eclipse.dashboard.widgets.StatusMapElement;
import org.netxms.ui.eclipse.dashboard.widgets.SyslogMonitorElement;
import org.netxms.ui.eclipse.dashboard.widgets.TableBarChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.TablePieChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.TableValueElement;
import org.netxms.ui.eclipse.dashboard.widgets.WebPageElement;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementConfig;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardElementLayout;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardModifyListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.layout.DashboardLayout;
import org.netxms.ui.eclipse.layout.DashboardLayoutData;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.IntermediateSelectionProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class DashboardControl
extends Composite {
    public static final String DEFAULT_CHART_CONFIG = "<element>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
    public static final String DEFAULT_LINE_CHART_CONFIG = "<element>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
    public static final String DEFAULT_DIAL_CHART_CONFIG = "<element>\n\t<maxValue>100</maxValue>\n\t<yellowZone>70</yellowZone>\n\t<redZone>90</redZone>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
    public static final String DEFAULT_AVAILABILITY_CHART_CONFIG = "<element>\n\t<objectId>0</objectId>\n</element>";
    public static final String DEFAULT_TABLE_CHART_CONFIG = "<element>\n\t<nodeId>0</nodeId>\n\t<dciId>0</dciId>\n\t<dataColumn>DATA</dataColumn>\n</element>";
    public static final String DEFAULT_OBJECT_REFERENCE_CONFIG = "<element>\n\t<objectId>0</objectId>\n</element>";
    public static final String DEFAULT_LABEL_CONFIG = "<element>\n\t<title>Label</title>\n</element>";
    public static final String DEFAULT_NETWORK_MAP_CONFIG = "<element>\n\t<objectId>0</objectId>\n\t<title></title>\n</element>";
    public static final String DEFAULT_GEO_MAP_CONFIG = "<element>\n\t<latitude>0</latitude>\n\t<longitude>0</longitude>\n\t<zoom>8</zoom>\t<title></title>\n</element>";
    public static final String DEFAULT_WEB_PAGE_CONFIG = "<element>\n\t<url>http://</url>\n\t<title></title>\n</element>";
    public static final String DEFAULT_TABLE_VALUE_CONFIG = "<element>\n\t<objectId>0</objectId>\n\t<dciId>0</dciId>\n\t<title></title>\n</element>";
    public static final String DEFAULT_SUMMARY_TABLE_CONFIG = "<element>\n\t<baseObjectId>0</baseObjectId>\n\t<tableId>0</tableId>\n</element>";
    private Dashboard dashboard;
    private AbstractObject context;
    private List<DashboardElement> elements;
    private Map<DashboardElement, ElementWidget> elementWidgets = new HashMap<DashboardElement, ElementWidget>();
    private int columnCount;
    private boolean embedded = false;
    private boolean editMode = false;
    private boolean modified = false;
    private DashboardModifyListener modifyListener = null;
    private IViewPart viewPart;
    private IntermediateSelectionProvider selectionProvider;

    public DashboardControl(Composite parent, int style, Dashboard dashboard, AbstractObject context, IViewPart viewPart, IntermediateSelectionProvider selectionProvider, boolean embedded) {
        super(parent, style);
        this.dashboard = dashboard;
        this.context = context;
        this.embedded = embedded;
        this.elements = new ArrayList<DashboardElement>(dashboard.getElements());
        this.columnCount = dashboard.getNumColumns();
        this.viewPart = viewPart;
        this.selectionProvider = selectionProvider;
        this.createContent();
    }

    public DashboardControl(Composite parent, int style, DashboardControl originalControl) {
        super(parent, style);
        this.dashboard = originalControl.dashboard;
        this.embedded = originalControl.embedded;
        this.modified = originalControl.modified;
        this.elements = new ArrayList<DashboardElement>(originalControl.elements);
        this.columnCount = originalControl.columnCount;
        this.viewPart = originalControl.viewPart;
        this.selectionProvider = originalControl.selectionProvider;
        this.createContent();
    }

    private void createContent() {
        this.setBackground(ThemeEngine.getBackgroundColor((String)"Dashboard"));
        DashboardLayout layout = new DashboardLayout();
        layout.numColumns = this.columnCount;
        layout.marginWidth = this.embedded ? 0 : 8;
        layout.marginHeight = this.embedded ? 0 : 8;
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 8;
        layout.scrollable = this.dashboard.isScrollable();
        this.setLayout((Layout)layout);
        for (DashboardElement e : this.elements) {
            this.createElementWidget(e);
        }
    }

    private ElementWidget createElementWidget(DashboardElement e) {
        ElementWidget w = switch (e.getType()) {
            case 11 -> new AlarmViewerElement(this, e, this.viewPart);
            case 12 -> new AvailabilityChartElement(this, e, this.viewPart);
            case 2, 4 -> new BarChartElement(this, e, this.viewPart);
            case 9 -> new CustomWidgetElement(this, e, this.viewPart);
            case 7 -> new EmbeddedDashboardElement(this, e, this.viewPart);
            case 21 -> new DciSummaryTableElement(this, e, this.viewPart);
            case 13 -> new GaugeElement(this, e, this.viewPart);
            case 24 -> new EventMonitorElement(this, e, this.viewPart);
            case 32 -> new FileMonitorElement(this, e, this.viewPart);
            case 10 -> new GeoMapElement(this, e, this.viewPart);
            case 0 -> new LabelElement(this, e, this.viewPart);
            case 1 -> new LineChartElement(this, e, this.viewPart);
            case 8 -> new NetworkMapElement(this, e, this.viewPart);
            case 28 -> new ObjectQuery(this, e, this.viewPart);
            case 27 -> new ObjectTools(this, e, this.viewPart);
            case 3 -> new PieChartElement(this, e, this.viewPart);
            case 29 -> new PortViewElement(this, e, this.viewPart);
            case 26 -> new RackDiagramElement(this, e, this.viewPart);
            case 30 -> new ScriptedBarChartElement(this, e, this.viewPart);
            case 31 -> new ScriptedPieChartElement(this, e, this.viewPart);
            case 18 -> new SeparatorElement(this, e, this.viewPart);
            case 25 -> new ServiceComponentsElement(this, e, this.viewPart);
            case 23 -> new SnmpTrapMonitorElement(this, e, this.viewPart);
            case 5 -> new ObjectStatusChartElement(this, e, this.viewPart);
            case 6 -> new StatusIndicatorElement(this, e, this.viewPart);
            case 20 -> new StatusMapElement(this, e, this.viewPart);
            case 22 -> new SyslogMonitorElement(this, e, this.viewPart);
            case 15, 17 -> new TableBarChartElement(this, e, this.viewPart);
            case 16 -> new TablePieChartElement(this, e, this.viewPart);
            case 19 -> new TableValueElement(this, e, this.viewPart);
            case 14 -> new WebPageElement(this, e, this.viewPart);
            default -> new ElementWidget(this, e, this.viewPart);
        };
        DashboardElementLayout el = w.getElementLayout();
        DashboardLayoutData gd = new DashboardLayoutData();
        gd.fill = el.grabVerticalSpace;
        gd.horizontalSpan = el.horizontalSpan;
        gd.verticalSpan = el.verticalSpan;
        gd.heightHint = el.heightHint;
        w.setLayoutData(gd);
        this.elementWidgets.put(e, w);
        return w;
    }

    private void redoLayout() {
        if (this.editMode) {
            this.setEditMode(false);
            this.layout(true, true);
            this.setEditMode(true);
        } else {
            this.layout(true, true);
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            if (c instanceof ElementWidget) {
                ((ElementWidget)c).setEditMode(editMode);
            }
            ++n2;
        }
    }

    void moveElement(DashboardElement element, int direction) {
        int index = this.elements.indexOf(element);
        if (index == -1) {
            return;
        }
        ElementWidget w = this.elementWidgets.get(element);
        if (direction == 16384 && index > 0) {
            Collections.swap(this.elements, index, index - 1);
            w.moveAbove((Control)this.elementWidgets.get(this.elements.get(index)));
        } else if (direction == 131072 && index < this.elements.size() - 1) {
            Collections.swap(this.elements, index, index + 1);
            w.moveBelow((Control)this.elementWidgets.get(this.elements.get(index)));
        } else {
            return;
        }
        this.redoLayout();
        this.setModified();
    }

    void changeElementSpan(DashboardElement element, int hSpanChange, int vSpanChange) {
        ElementWidget w = this.elementWidgets.get(element);
        if (w == null) {
            return;
        }
        DashboardElementLayout el = w.getElementLayout();
        int hSpan = el.horizontalSpan + hSpanChange;
        int vSpan = el.verticalSpan + vSpanChange;
        if (hSpan < 1 || vSpan < 1 || hSpan > this.columnCount) {
            return;
        }
        el.horizontalSpan = hSpan;
        el.verticalSpan = vSpan;
        try {
            element.setLayout(new Gson().toJson((Object)el));
        }
        catch (Exception e) {
            Activator.logError("Error serializing updated dashboard element layout", e);
        }
        DashboardLayoutData gd = (DashboardLayoutData)w.getLayoutData();
        gd.horizontalSpan = el.horizontalSpan;
        gd.verticalSpan = el.verticalSpan;
        this.redoLayout();
        this.setModified();
    }

    void setElementFullHSpan(DashboardElement element) {
        ElementWidget w = this.elementWidgets.get(element);
        if (w == null) {
            return;
        }
        DashboardElementLayout el = w.getElementLayout();
        if (el.horizontalSpan == this.columnCount) {
            return;
        }
        el.horizontalSpan = this.columnCount;
        try {
            element.setLayout(new Gson().toJson((Object)el));
        }
        catch (Exception e) {
            Activator.logError("Error serializing updated dashboard element layout", e);
        }
        DashboardLayoutData gd = (DashboardLayoutData)w.getLayoutData();
        gd.horizontalSpan = el.horizontalSpan;
        this.redoLayout();
        this.setModified();
    }

    void duplicateElement(DashboardElement src) {
        DashboardElement element = new DashboardElement(src);
        this.elements.add(element);
        this.createElementWidget(element);
        this.redoLayout();
        this.setModified();
    }

    void deleteElement(DashboardElement element) {
        this.elements.remove(element);
        ElementWidget w = this.elementWidgets.get(element);
        if (w != null) {
            this.elementWidgets.remove(element);
            w.dispose();
            this.redoLayout();
        }
        this.setModified();
    }

    private Control getNextWidget(Control curr) {
        Control[] children = this.getChildren();
        int i = 0;
        while (i < children.length - 1) {
            if (children[i] == curr) {
                return children[i + 1];
            }
            ++i;
        }
        return null;
    }

    void editElement(DashboardElement element) {
        DashboardElementConfig config = (DashboardElementConfig)AdapterManager.getDefault().getAdapter((Object)element, DashboardElementConfig.class);
        if (config != null) {
            try {
                Gson gson = new Gson();
                config.setLayout((DashboardElementLayout)gson.fromJson(element.getLayout(), DashboardElementLayout.class));
                PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getShell(), null, (Object)config);
                if (dlg.open() == 1) {
                    return;
                }
                element.setData(config.createJson());
                element.setLayout(gson.toJson((Object)config.getLayout()));
                this.recreateElement(element);
                this.redoLayout();
                this.setModified();
            }
            catch (Exception e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.DashboardControl_InternalError, (String)(String.valueOf(Messages.DashboardControl_InternalErrorPrefix) + e.getMessage()));
            }
        } else {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.DashboardControl_InternalError, (String)Messages.DashboardControl_InternalErrorText1);
        }
    }

    void editElementXml(DashboardElement element) {
        EditElementXmlDlg dlg = new EditElementXmlDlg(this.getShell(), element.getData());
        if (dlg.open() == 0) {
            element.setData(dlg.getValue());
            this.recreateElement(element);
            this.redoLayout();
            this.setModified();
        }
    }

    private void recreateElement(DashboardElement element) {
        ElementWidget w = this.elementWidgets.get(element);
        Control next = this.getNextWidget((Control)w);
        w.dispose();
        w = this.createElementWidget(element);
        if (next != null) {
            w.moveAbove(next);
        }
        this.elementWidgets.put(element, w);
    }

    public void addElement(DashboardElement element) {
        DashboardElementConfig config = (DashboardElementConfig)AdapterManager.getDefault().getAdapter((Object)element, DashboardElementConfig.class);
        if (config != null) {
            try {
                Gson gson = new Gson();
                config.setLayout((DashboardElementLayout)gson.fromJson(element.getLayout(), DashboardElementLayout.class));
                PropertyDialog dlg = PropertyDialog.createDialogOn((Shell)this.getShell(), null, (Object)config);
                if (dlg.open() == 1) {
                    return;
                }
                element.setData(config.createJson());
                element.setLayout(gson.toJson((Object)config.getLayout()));
                element.setIndex(this.elements.size());
                this.elements.add(element);
                this.createElementWidget(element);
                this.redoLayout();
                this.setModified();
            }
            catch (Exception e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.DashboardControl_InternalError, (String)(String.valueOf(Messages.DashboardControl_InternalErrorPrefix) + e.getMessage()));
            }
        } else {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.DashboardControl_InternalError, (String)Messages.DashboardControl_InternalErrorText2);
        }
    }

    public void addColumn() {
        if (this.columnCount == 128) {
            return;
        }
        ++this.columnCount;
        ((DashboardLayout)this.getLayout()).numColumns = this.columnCount;
        this.layout(true, true);
        this.setModified();
    }

    public void removeColumn() {
        if (this.columnCount == this.getMinimalColumnCount()) {
            return;
        }
        --this.columnCount;
        ((DashboardLayout)this.getLayout()).numColumns = this.columnCount;
        this.layout(true, true);
        this.setModified();
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getMinimalColumnCount() {
        int count = 1;
        for (DashboardElement element : this.elements) {
            try {
                DashboardElementLayout layout = (DashboardElementLayout)new Gson().fromJson(element.getLayout(), DashboardElementLayout.class);
                if (layout.horizontalSpan <= count) continue;
                count = layout.horizontalSpan;
            }
            catch (Exception e) {
                Activator.logError("Cannot parse dashboard element layout", e);
            }
        }
        return count;
    }

    public void saveDashboard(IViewPart viewPart) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.dashboard.getObjectId());
        md.setDashboardElements(new ArrayList<DashboardElement>(this.elements));
        md.setColumnCount(this.columnCount);
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.DashboardControl_SaveLayout, (IWorkbenchPart)viewPart, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (DashboardControl.this.isDisposed()) {
                            return;
                        }
                        (this).DashboardControl.this.modified = false;
                        if ((this).DashboardControl.this.modifyListener != null) {
                            (this).DashboardControl.this.modifyListener.save();
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.DashboardControl_SaveError) + DashboardControl.this.dashboard.getObjectName();
            }
        }.start();
    }

    private void setModified() {
        this.modified = true;
        if (this.modifyListener != null) {
            this.modifyListener.modify();
        }
    }

    public DashboardModifyListener getModifyListener() {
        return this.modifyListener;
    }

    public void setModifyListener(DashboardModifyListener modifyListener) {
        this.modifyListener = modifyListener;
    }

    public boolean isModified() {
        return this.modified;
    }

    public List<DashboardElement> getElements() {
        return this.elements;
    }

    public List<ElementWidget> getElementWidgets() {
        return new ArrayList<ElementWidget>(this.elementWidgets.values());
    }

    public IntermediateSelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public Dashboard getDashboardObject() {
        return this.dashboard;
    }

    public AbstractObject getContext() {
        return this.context;
    }

    public void requestDashboardLayout() {
        if (this.viewPart != null && this.viewPart instanceof DashboardControlOwner) {
            ((DashboardControlOwner)this.viewPart).requestDashboardLayout();
        } else {
            this.layout(true, true);
        }
    }
}

